package zio.aws.iam.model
import zio.aws.iam.model.primitives.ArnType
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AttachedPermissionsBoundary(
    permissionsBoundaryType: Option[
      zio.aws.iam.model.PermissionsBoundaryAttachmentType
    ] = None,
    permissionsBoundaryArn: Option[ArnType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.AttachedPermissionsBoundary = {
    import AttachedPermissionsBoundary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.AttachedPermissionsBoundary
      .builder()
      .optionallyWith(permissionsBoundaryType.map(value => value.unwrap))(
        _.permissionsBoundaryType
      )
      .optionallyWith(
        permissionsBoundaryArn.map(value =>
          ArnType.unwrap(value): java.lang.String
        )
      )(_.permissionsBoundaryArn)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.AttachedPermissionsBoundary.ReadOnly =
    zio.aws.iam.model.AttachedPermissionsBoundary.wrap(buildAwsValue())
}
object AttachedPermissionsBoundary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.AttachedPermissionsBoundary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.AttachedPermissionsBoundary =
      zio.aws.iam.model.AttachedPermissionsBoundary(
        permissionsBoundaryType.map(value => value),
        permissionsBoundaryArn.map(value => value)
      )
    def permissionsBoundaryType
        : Option[zio.aws.iam.model.PermissionsBoundaryAttachmentType]
    def permissionsBoundaryArn: Option[ArnType]
    def getPermissionsBoundaryType: ZIO[
      Any,
      AwsError,
      zio.aws.iam.model.PermissionsBoundaryAttachmentType
    ] = AwsError.unwrapOptionField(
      "permissionsBoundaryType",
      permissionsBoundaryType
    )
    def getPermissionsBoundaryArn: ZIO[Any, AwsError, ArnType] = AwsError
      .unwrapOptionField("permissionsBoundaryArn", permissionsBoundaryArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.AttachedPermissionsBoundary
  ) extends zio.aws.iam.model.AttachedPermissionsBoundary.ReadOnly {
    override val permissionsBoundaryType
        : Option[zio.aws.iam.model.PermissionsBoundaryAttachmentType] = scala
      .Option(impl.permissionsBoundaryType())
      .map(value =>
        zio.aws.iam.model.PermissionsBoundaryAttachmentType.wrap(value)
      )
    override val permissionsBoundaryArn: Option[ArnType] = scala
      .Option(impl.permissionsBoundaryArn())
      .map(value => zio.aws.iam.model.primitives.ArnType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.AttachedPermissionsBoundary
  ): zio.aws.iam.model.AttachedPermissionsBoundary.ReadOnly = new Wrapper(impl)
}
