package zio.aws.iam.model
import zio.aws.iam.model.primitives.{ArnType, PolicyNameType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AttachedPolicy(
    policyName: Option[PolicyNameType] = None,
    policyArn: Option[ArnType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.AttachedPolicy = {
    import AttachedPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.AttachedPolicy
      .builder()
      .optionallyWith(
        policyName.map(value => PolicyNameType.unwrap(value): java.lang.String)
      )(_.policyName)
      .optionallyWith(
        policyArn.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.policyArn)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.AttachedPolicy.ReadOnly =
    zio.aws.iam.model.AttachedPolicy.wrap(buildAwsValue())
}
object AttachedPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.AttachedPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.AttachedPolicy =
      zio.aws.iam.model.AttachedPolicy(
        policyName.map(value => value),
        policyArn.map(value => value)
      )
    def policyName: Option[PolicyNameType]
    def policyArn: Option[ArnType]
    def getPolicyName: ZIO[Any, AwsError, PolicyNameType] =
      AwsError.unwrapOptionField("policyName", policyName)
    def getPolicyArn: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("policyArn", policyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.AttachedPolicy
  ) extends zio.aws.iam.model.AttachedPolicy.ReadOnly {
    override val policyName: Option[PolicyNameType] = scala
      .Option(impl.policyName())
      .map(value => zio.aws.iam.model.primitives.PolicyNameType(value))
    override val policyArn: Option[ArnType] = scala
      .Option(impl.policyArn())
      .map(value => zio.aws.iam.model.primitives.ArnType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.AttachedPolicy
  ): zio.aws.iam.model.AttachedPolicy.ReadOnly = new Wrapper(impl)
}
