package zio.aws.iam.model
import zio.aws.iam.model.primitives.{ContextKeyValueType, ContextKeyNameType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ContextEntry(
    contextKeyName: Option[ContextKeyNameType] = None,
    contextKeyValues: Option[Iterable[ContextKeyValueType]] = None,
    contextKeyType: Option[zio.aws.iam.model.ContextKeyTypeEnum] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ContextEntry = {
    import ContextEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ContextEntry
      .builder()
      .optionallyWith(
        contextKeyName.map(value =>
          ContextKeyNameType.unwrap(value): java.lang.String
        )
      )(_.contextKeyName)
      .optionallyWith(
        contextKeyValues.map(value =>
          value.map { item =>
            ContextKeyValueType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.contextKeyValues)
      .optionallyWith(contextKeyType.map(value => value.unwrap))(
        _.contextKeyType
      )
      .build()
  }
  def asReadOnly: zio.aws.iam.model.ContextEntry.ReadOnly =
    zio.aws.iam.model.ContextEntry.wrap(buildAwsValue())
}
object ContextEntry {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iam.model.ContextEntry] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ContextEntry =
      zio.aws.iam.model.ContextEntry(
        contextKeyName.map(value => value),
        contextKeyValues.map(value => value),
        contextKeyType.map(value => value)
      )
    def contextKeyName: Option[ContextKeyNameType]
    def contextKeyValues: Option[List[ContextKeyValueType]]
    def contextKeyType: Option[zio.aws.iam.model.ContextKeyTypeEnum]
    def getContextKeyName: ZIO[Any, AwsError, ContextKeyNameType] =
      AwsError.unwrapOptionField("contextKeyName", contextKeyName)
    def getContextKeyValues: ZIO[Any, AwsError, List[ContextKeyValueType]] =
      AwsError.unwrapOptionField("contextKeyValues", contextKeyValues)
    def getContextKeyType
        : ZIO[Any, AwsError, zio.aws.iam.model.ContextKeyTypeEnum] =
      AwsError.unwrapOptionField("contextKeyType", contextKeyType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ContextEntry
  ) extends zio.aws.iam.model.ContextEntry.ReadOnly {
    override val contextKeyName: Option[ContextKeyNameType] = scala
      .Option(impl.contextKeyName())
      .map(value => zio.aws.iam.model.primitives.ContextKeyNameType(value))
    override val contextKeyValues: Option[List[ContextKeyValueType]] = scala
      .Option(impl.contextKeyValues())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iam.model.primitives.ContextKeyValueType(item)
        }.toList
      )
    override val contextKeyType: Option[zio.aws.iam.model.ContextKeyTypeEnum] =
      scala
        .Option(impl.contextKeyType())
        .map(value => zio.aws.iam.model.ContextKeyTypeEnum.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ContextEntry
  ): zio.aws.iam.model.ContextEntry.ReadOnly = new Wrapper(impl)
}
