package zio.aws.iam.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateAccessKeyResponse(
    accessKey: zio.aws.iam.model.AccessKey
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.CreateAccessKeyResponse = {
    import CreateAccessKeyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.CreateAccessKeyResponse
      .builder()
      .accessKey(accessKey.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.iam.model.CreateAccessKeyResponse.ReadOnly =
    zio.aws.iam.model.CreateAccessKeyResponse.wrap(buildAwsValue())
}
object CreateAccessKeyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.CreateAccessKeyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.CreateAccessKeyResponse =
      zio.aws.iam.model.CreateAccessKeyResponse(accessKey.asEditable)
    def accessKey: zio.aws.iam.model.AccessKey.ReadOnly
    def getAccessKey: ZIO[Any, Nothing, zio.aws.iam.model.AccessKey.ReadOnly] =
      ZIO.succeed(accessKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.CreateAccessKeyResponse
  ) extends zio.aws.iam.model.CreateAccessKeyResponse.ReadOnly {
    override val accessKey: zio.aws.iam.model.AccessKey.ReadOnly =
      zio.aws.iam.model.AccessKey.wrap(impl.accessKey())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.CreateAccessKeyResponse
  ): zio.aws.iam.model.CreateAccessKeyResponse.ReadOnly = new Wrapper(impl)
}
