package zio.aws.iam.model
import zio.aws.iam.model.primitives.{GroupNameType, PathType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateGroupRequest(
    path: Option[PathType] = None,
    groupName: GroupNameType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.CreateGroupRequest = {
    import CreateGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.CreateGroupRequest
      .builder()
      .optionallyWith(
        path.map(value => PathType.unwrap(value): java.lang.String)
      )(_.path)
      .groupName(GroupNameType.unwrap(groupName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.CreateGroupRequest.ReadOnly =
    zio.aws.iam.model.CreateGroupRequest.wrap(buildAwsValue())
}
object CreateGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.CreateGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.CreateGroupRequest =
      zio.aws.iam.model.CreateGroupRequest(path.map(value => value), groupName)
    def path: Option[PathType]
    def groupName: GroupNameType
    def getPath: ZIO[Any, AwsError, PathType] =
      AwsError.unwrapOptionField("path", path)
    def getGroupName: ZIO[Any, Nothing, GroupNameType] = ZIO.succeed(groupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.CreateGroupRequest
  ) extends zio.aws.iam.model.CreateGroupRequest.ReadOnly {
    override val path: Option[PathType] = scala
      .Option(impl.path())
      .map(value => zio.aws.iam.model.primitives.PathType(value))
    override val groupName: GroupNameType =
      zio.aws.iam.model.primitives.GroupNameType(impl.groupName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.CreateGroupRequest
  ): zio.aws.iam.model.CreateGroupRequest.ReadOnly = new Wrapper(impl)
}
