package zio.aws.iam.model
import zio.aws.iam.model.primitives.{
  PolicyDescriptionType,
  PolicyDocumentType,
  PolicyPathType,
  PolicyNameType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreatePolicyRequest(
    policyName: PolicyNameType,
    path: Option[PolicyPathType] = None,
    policyDocument: PolicyDocumentType,
    description: Option[PolicyDescriptionType] = None,
    tags: Option[Iterable[zio.aws.iam.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.CreatePolicyRequest = {
    import CreatePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.CreatePolicyRequest
      .builder()
      .policyName(PolicyNameType.unwrap(policyName): java.lang.String)
      .optionallyWith(
        path.map(value => PolicyPathType.unwrap(value): java.lang.String)
      )(_.path)
      .policyDocument(
        PolicyDocumentType.unwrap(policyDocument): java.lang.String
      )
      .optionallyWith(
        description.map(value =>
          PolicyDescriptionType.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.CreatePolicyRequest.ReadOnly =
    zio.aws.iam.model.CreatePolicyRequest.wrap(buildAwsValue())
}
object CreatePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.CreatePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.CreatePolicyRequest =
      zio.aws.iam.model.CreatePolicyRequest(
        policyName,
        path.map(value => value),
        policyDocument,
        description.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def policyName: PolicyNameType
    def path: Option[PolicyPathType]
    def policyDocument: PolicyDocumentType
    def description: Option[PolicyDescriptionType]
    def tags: Option[List[zio.aws.iam.model.Tag.ReadOnly]]
    def getPolicyName: ZIO[Any, Nothing, PolicyNameType] =
      ZIO.succeed(policyName)
    def getPath: ZIO[Any, AwsError, PolicyPathType] =
      AwsError.unwrapOptionField("path", path)
    def getPolicyDocument: ZIO[Any, Nothing, PolicyDocumentType] =
      ZIO.succeed(policyDocument)
    def getDescription: ZIO[Any, AwsError, PolicyDescriptionType] =
      AwsError.unwrapOptionField("description", description)
    def getTags: ZIO[Any, AwsError, List[zio.aws.iam.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.CreatePolicyRequest
  ) extends zio.aws.iam.model.CreatePolicyRequest.ReadOnly {
    override val policyName: PolicyNameType =
      zio.aws.iam.model.primitives.PolicyNameType(impl.policyName())
    override val path: Option[PolicyPathType] = scala
      .Option(impl.path())
      .map(value => zio.aws.iam.model.primitives.PolicyPathType(value))
    override val policyDocument: PolicyDocumentType =
      zio.aws.iam.model.primitives.PolicyDocumentType(impl.policyDocument())
    override val description: Option[PolicyDescriptionType] = scala
      .Option(impl.description())
      .map(value => zio.aws.iam.model.primitives.PolicyDescriptionType(value))
    override val tags: Option[List[zio.aws.iam.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iam.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.CreatePolicyRequest
  ): zio.aws.iam.model.CreatePolicyRequest.ReadOnly = new Wrapper(impl)
}
