package zio.aws.iam.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreatePolicyResponse(
    policy: Option[zio.aws.iam.model.Policy] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.CreatePolicyResponse = {
    import CreatePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.CreatePolicyResponse
      .builder()
      .optionallyWith(policy.map(value => value.buildAwsValue()))(_.policy)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.CreatePolicyResponse.ReadOnly =
    zio.aws.iam.model.CreatePolicyResponse.wrap(buildAwsValue())
}
object CreatePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.CreatePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.CreatePolicyResponse = zio.aws.iam.model
      .CreatePolicyResponse(policy.map(value => value.asEditable))
    def policy: Option[zio.aws.iam.model.Policy.ReadOnly]
    def getPolicy: ZIO[Any, AwsError, zio.aws.iam.model.Policy.ReadOnly] =
      AwsError.unwrapOptionField("policy", policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.CreatePolicyResponse
  ) extends zio.aws.iam.model.CreatePolicyResponse.ReadOnly {
    override val policy: Option[zio.aws.iam.model.Policy.ReadOnly] = scala
      .Option(impl.policy())
      .map(value => zio.aws.iam.model.Policy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.CreatePolicyResponse
  ): zio.aws.iam.model.CreatePolicyResponse.ReadOnly = new Wrapper(impl)
}
