package zio.aws.iam.model
import java.lang.Integer
import zio.aws.iam.model.primitives.{
  ArnType,
  RoleNameType,
  RoleDescriptionType,
  PolicyDocumentType,
  RoleMaxSessionDurationType,
  PathType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateRoleRequest(
    path: Option[PathType] = None,
    roleName: RoleNameType,
    assumeRolePolicyDocument: PolicyDocumentType,
    description: Option[RoleDescriptionType] = None,
    maxSessionDuration: Option[RoleMaxSessionDurationType] = None,
    permissionsBoundary: Option[ArnType] = None,
    tags: Option[Iterable[zio.aws.iam.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.CreateRoleRequest = {
    import CreateRoleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.CreateRoleRequest
      .builder()
      .optionallyWith(
        path.map(value => PathType.unwrap(value): java.lang.String)
      )(_.path)
      .roleName(RoleNameType.unwrap(roleName): java.lang.String)
      .assumeRolePolicyDocument(
        PolicyDocumentType.unwrap(assumeRolePolicyDocument): java.lang.String
      )
      .optionallyWith(
        description.map(value =>
          RoleDescriptionType.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        maxSessionDuration.map(value =>
          RoleMaxSessionDurationType.unwrap(value): Integer
        )
      )(_.maxSessionDuration)
      .optionallyWith(
        permissionsBoundary.map(value =>
          ArnType.unwrap(value): java.lang.String
        )
      )(_.permissionsBoundary)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.CreateRoleRequest.ReadOnly =
    zio.aws.iam.model.CreateRoleRequest.wrap(buildAwsValue())
}
object CreateRoleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.CreateRoleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.CreateRoleRequest =
      zio.aws.iam.model.CreateRoleRequest(
        path.map(value => value),
        roleName,
        assumeRolePolicyDocument,
        description.map(value => value),
        maxSessionDuration.map(value => value),
        permissionsBoundary.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def path: Option[PathType]
    def roleName: RoleNameType
    def assumeRolePolicyDocument: PolicyDocumentType
    def description: Option[RoleDescriptionType]
    def maxSessionDuration: Option[RoleMaxSessionDurationType]
    def permissionsBoundary: Option[ArnType]
    def tags: Option[List[zio.aws.iam.model.Tag.ReadOnly]]
    def getPath: ZIO[Any, AwsError, PathType] =
      AwsError.unwrapOptionField("path", path)
    def getRoleName: ZIO[Any, Nothing, RoleNameType] = ZIO.succeed(roleName)
    def getAssumeRolePolicyDocument: ZIO[Any, Nothing, PolicyDocumentType] =
      ZIO.succeed(assumeRolePolicyDocument)
    def getDescription: ZIO[Any, AwsError, RoleDescriptionType] =
      AwsError.unwrapOptionField("description", description)
    def getMaxSessionDuration: ZIO[Any, AwsError, RoleMaxSessionDurationType] =
      AwsError.unwrapOptionField("maxSessionDuration", maxSessionDuration)
    def getPermissionsBoundary: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("permissionsBoundary", permissionsBoundary)
    def getTags: ZIO[Any, AwsError, List[zio.aws.iam.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.CreateRoleRequest
  ) extends zio.aws.iam.model.CreateRoleRequest.ReadOnly {
    override val path: Option[PathType] = scala
      .Option(impl.path())
      .map(value => zio.aws.iam.model.primitives.PathType(value))
    override val roleName: RoleNameType =
      zio.aws.iam.model.primitives.RoleNameType(impl.roleName())
    override val assumeRolePolicyDocument: PolicyDocumentType =
      zio.aws.iam.model.primitives
        .PolicyDocumentType(impl.assumeRolePolicyDocument())
    override val description: Option[RoleDescriptionType] = scala
      .Option(impl.description())
      .map(value => zio.aws.iam.model.primitives.RoleDescriptionType(value))
    override val maxSessionDuration: Option[RoleMaxSessionDurationType] = scala
      .Option(impl.maxSessionDuration())
      .map(value =>
        zio.aws.iam.model.primitives.RoleMaxSessionDurationType(value)
      )
    override val permissionsBoundary: Option[ArnType] = scala
      .Option(impl.permissionsBoundary())
      .map(value => zio.aws.iam.model.primitives.ArnType(value))
    override val tags: Option[List[zio.aws.iam.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iam.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.CreateRoleRequest
  ): zio.aws.iam.model.CreateRoleRequest.ReadOnly = new Wrapper(impl)
}
