package zio.aws.iam.model
import zio.aws.iam.model.primitives.{
  SAMLProviderNameType,
  SAMLMetadataDocumentType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateSamlProviderRequest(
    samlMetadataDocument: SAMLMetadataDocumentType,
    name: SAMLProviderNameType,
    tags: Option[Iterable[zio.aws.iam.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.CreateSamlProviderRequest = {
    import CreateSamlProviderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.CreateSamlProviderRequest
      .builder()
      .samlMetadataDocument(
        SAMLMetadataDocumentType.unwrap(samlMetadataDocument): java.lang.String
      )
      .name(SAMLProviderNameType.unwrap(name): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.CreateSamlProviderRequest.ReadOnly =
    zio.aws.iam.model.CreateSamlProviderRequest.wrap(buildAwsValue())
}
object CreateSamlProviderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.CreateSamlProviderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.CreateSamlProviderRequest =
      zio.aws.iam.model.CreateSamlProviderRequest(
        samlMetadataDocument,
        name,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def samlMetadataDocument: SAMLMetadataDocumentType
    def name: SAMLProviderNameType
    def tags: Option[List[zio.aws.iam.model.Tag.ReadOnly]]
    def getSamlMetadataDocument: ZIO[Any, Nothing, SAMLMetadataDocumentType] =
      ZIO.succeed(samlMetadataDocument)
    def getName: ZIO[Any, Nothing, SAMLProviderNameType] = ZIO.succeed(name)
    def getTags: ZIO[Any, AwsError, List[zio.aws.iam.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.CreateSamlProviderRequest
  ) extends zio.aws.iam.model.CreateSamlProviderRequest.ReadOnly {
    override val samlMetadataDocument: SAMLMetadataDocumentType =
      zio.aws.iam.model.primitives
        .SAMLMetadataDocumentType(impl.samlMetadataDocument())
    override val name: SAMLProviderNameType =
      zio.aws.iam.model.primitives.SAMLProviderNameType(impl.name())
    override val tags: Option[List[zio.aws.iam.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iam.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.CreateSamlProviderRequest
  ): zio.aws.iam.model.CreateSamlProviderRequest.ReadOnly = new Wrapper(impl)
}
