package zio.aws.iam.model
import zio.aws.iam.model.primitives.ArnType
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateSamlProviderResponse(
    samlProviderArn: Option[ArnType] = None,
    tags: Option[Iterable[zio.aws.iam.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.CreateSamlProviderResponse = {
    import CreateSamlProviderResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.CreateSamlProviderResponse
      .builder()
      .optionallyWith(
        samlProviderArn.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.samlProviderArn)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.CreateSamlProviderResponse.ReadOnly =
    zio.aws.iam.model.CreateSamlProviderResponse.wrap(buildAwsValue())
}
object CreateSamlProviderResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.CreateSamlProviderResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.CreateSamlProviderResponse =
      zio.aws.iam.model.CreateSamlProviderResponse(
        samlProviderArn.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def samlProviderArn: Option[ArnType]
    def tags: Option[List[zio.aws.iam.model.Tag.ReadOnly]]
    def getSamlProviderArn: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("samlProviderArn", samlProviderArn)
    def getTags: ZIO[Any, AwsError, List[zio.aws.iam.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.CreateSamlProviderResponse
  ) extends zio.aws.iam.model.CreateSamlProviderResponse.ReadOnly {
    override val samlProviderArn: Option[ArnType] = scala
      .Option(impl.samlProviderArn())
      .map(value => zio.aws.iam.model.primitives.ArnType(value))
    override val tags: Option[List[zio.aws.iam.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iam.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.CreateSamlProviderResponse
  ): zio.aws.iam.model.CreateSamlProviderResponse.ReadOnly = new Wrapper(impl)
}
