package zio.aws.iam.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateServiceLinkedRoleResponse(
    role: Option[zio.aws.iam.model.Role] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.CreateServiceLinkedRoleResponse = {
    import CreateServiceLinkedRoleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.CreateServiceLinkedRoleResponse
      .builder()
      .optionallyWith(role.map(value => value.buildAwsValue()))(_.role)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.CreateServiceLinkedRoleResponse.ReadOnly =
    zio.aws.iam.model.CreateServiceLinkedRoleResponse.wrap(buildAwsValue())
}
object CreateServiceLinkedRoleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.CreateServiceLinkedRoleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.CreateServiceLinkedRoleResponse =
      zio.aws.iam.model
        .CreateServiceLinkedRoleResponse(role.map(value => value.asEditable))
    def role: Option[zio.aws.iam.model.Role.ReadOnly]
    def getRole: ZIO[Any, AwsError, zio.aws.iam.model.Role.ReadOnly] =
      AwsError.unwrapOptionField("role", role)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.CreateServiceLinkedRoleResponse
  ) extends zio.aws.iam.model.CreateServiceLinkedRoleResponse.ReadOnly {
    override val role: Option[zio.aws.iam.model.Role.ReadOnly] =
      scala.Option(impl.role()).map(value => zio.aws.iam.model.Role.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.CreateServiceLinkedRoleResponse
  ): zio.aws.iam.model.CreateServiceLinkedRoleResponse.ReadOnly = new Wrapper(
    impl
  )
}
