package zio.aws.iam.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateServiceSpecificCredentialResponse(
    serviceSpecificCredential: Option[
      zio.aws.iam.model.ServiceSpecificCredential
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.CreateServiceSpecificCredentialResponse = {
    import CreateServiceSpecificCredentialResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.CreateServiceSpecificCredentialResponse
      .builder()
      .optionallyWith(
        serviceSpecificCredential.map(value => value.buildAwsValue())
      )(_.serviceSpecificCredential)
      .build()
  }
  def asReadOnly
      : zio.aws.iam.model.CreateServiceSpecificCredentialResponse.ReadOnly =
    zio.aws.iam.model.CreateServiceSpecificCredentialResponse
      .wrap(buildAwsValue())
}
object CreateServiceSpecificCredentialResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.CreateServiceSpecificCredentialResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.CreateServiceSpecificCredentialResponse =
      zio.aws.iam.model.CreateServiceSpecificCredentialResponse(
        serviceSpecificCredential.map(value => value.asEditable)
      )
    def serviceSpecificCredential
        : Option[zio.aws.iam.model.ServiceSpecificCredential.ReadOnly]
    def getServiceSpecificCredential: ZIO[
      Any,
      AwsError,
      zio.aws.iam.model.ServiceSpecificCredential.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serviceSpecificCredential",
      serviceSpecificCredential
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.CreateServiceSpecificCredentialResponse
  ) extends zio.aws.iam.model.CreateServiceSpecificCredentialResponse.ReadOnly {
    override val serviceSpecificCredential
        : Option[zio.aws.iam.model.ServiceSpecificCredential.ReadOnly] = scala
      .Option(impl.serviceSpecificCredential())
      .map(value => zio.aws.iam.model.ServiceSpecificCredential.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.CreateServiceSpecificCredentialResponse
  ): zio.aws.iam.model.CreateServiceSpecificCredentialResponse.ReadOnly =
    new Wrapper(impl)
}
