package zio.aws.iam.model
import zio.aws.iam.model.primitives.{ArnType, UserNameType, PathType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateUserRequest(
    path: Option[PathType] = None,
    userName: UserNameType,
    permissionsBoundary: Option[ArnType] = None,
    tags: Option[Iterable[zio.aws.iam.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.CreateUserRequest = {
    import CreateUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.CreateUserRequest
      .builder()
      .optionallyWith(
        path.map(value => PathType.unwrap(value): java.lang.String)
      )(_.path)
      .userName(UserNameType.unwrap(userName): java.lang.String)
      .optionallyWith(
        permissionsBoundary.map(value =>
          ArnType.unwrap(value): java.lang.String
        )
      )(_.permissionsBoundary)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.CreateUserRequest.ReadOnly =
    zio.aws.iam.model.CreateUserRequest.wrap(buildAwsValue())
}
object CreateUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.CreateUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.CreateUserRequest =
      zio.aws.iam.model.CreateUserRequest(
        path.map(value => value),
        userName,
        permissionsBoundary.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def path: Option[PathType]
    def userName: UserNameType
    def permissionsBoundary: Option[ArnType]
    def tags: Option[List[zio.aws.iam.model.Tag.ReadOnly]]
    def getPath: ZIO[Any, AwsError, PathType] =
      AwsError.unwrapOptionField("path", path)
    def getUserName: ZIO[Any, Nothing, UserNameType] = ZIO.succeed(userName)
    def getPermissionsBoundary: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("permissionsBoundary", permissionsBoundary)
    def getTags: ZIO[Any, AwsError, List[zio.aws.iam.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.CreateUserRequest
  ) extends zio.aws.iam.model.CreateUserRequest.ReadOnly {
    override val path: Option[PathType] = scala
      .Option(impl.path())
      .map(value => zio.aws.iam.model.primitives.PathType(value))
    override val userName: UserNameType =
      zio.aws.iam.model.primitives.UserNameType(impl.userName())
    override val permissionsBoundary: Option[ArnType] = scala
      .Option(impl.permissionsBoundary())
      .map(value => zio.aws.iam.model.primitives.ArnType(value))
    override val tags: Option[List[zio.aws.iam.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iam.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.CreateUserRequest
  ): zio.aws.iam.model.CreateUserRequest.ReadOnly = new Wrapper(impl)
}
