package zio.aws.iam.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateUserResponse(
    user: Option[zio.aws.iam.model.User] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.CreateUserResponse = {
    import CreateUserResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.CreateUserResponse
      .builder()
      .optionallyWith(user.map(value => value.buildAwsValue()))(_.user)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.CreateUserResponse.ReadOnly =
    zio.aws.iam.model.CreateUserResponse.wrap(buildAwsValue())
}
object CreateUserResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.CreateUserResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.CreateUserResponse =
      zio.aws.iam.model.CreateUserResponse(user.map(value => value.asEditable))
    def user: Option[zio.aws.iam.model.User.ReadOnly]
    def getUser: ZIO[Any, AwsError, zio.aws.iam.model.User.ReadOnly] =
      AwsError.unwrapOptionField("user", user)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.CreateUserResponse
  ) extends zio.aws.iam.model.CreateUserResponse.ReadOnly {
    override val user: Option[zio.aws.iam.model.User.ReadOnly] =
      scala.Option(impl.user()).map(value => zio.aws.iam.model.User.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.CreateUserResponse
  ): zio.aws.iam.model.CreateUserResponse.ReadOnly = new Wrapper(impl)
}
