package zio.aws.iam.model
import zio.aws.iam.model.primitives.{AccessKeyIdType, ExistingUserNameType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteAccessKeyRequest(
    userName: Option[ExistingUserNameType] = None,
    accessKeyId: AccessKeyIdType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.DeleteAccessKeyRequest = {
    import DeleteAccessKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.DeleteAccessKeyRequest
      .builder()
      .optionallyWith(
        userName.map(value =>
          ExistingUserNameType.unwrap(value): java.lang.String
        )
      )(_.userName)
      .accessKeyId(AccessKeyIdType.unwrap(accessKeyId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.DeleteAccessKeyRequest.ReadOnly =
    zio.aws.iam.model.DeleteAccessKeyRequest.wrap(buildAwsValue())
}
object DeleteAccessKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.DeleteAccessKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.DeleteAccessKeyRequest = zio.aws.iam.model
      .DeleteAccessKeyRequest(userName.map(value => value), accessKeyId)
    def userName: Option[ExistingUserNameType]
    def accessKeyId: AccessKeyIdType
    def getUserName: ZIO[Any, AwsError, ExistingUserNameType] =
      AwsError.unwrapOptionField("userName", userName)
    def getAccessKeyId: ZIO[Any, Nothing, AccessKeyIdType] =
      ZIO.succeed(accessKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.DeleteAccessKeyRequest
  ) extends zio.aws.iam.model.DeleteAccessKeyRequest.ReadOnly {
    override val userName: Option[ExistingUserNameType] = scala
      .Option(impl.userName())
      .map(value => zio.aws.iam.model.primitives.ExistingUserNameType(value))
    override val accessKeyId: AccessKeyIdType =
      zio.aws.iam.model.primitives.AccessKeyIdType(impl.accessKeyId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.DeleteAccessKeyRequest
  ): zio.aws.iam.model.DeleteAccessKeyRequest.ReadOnly = new Wrapper(impl)
}
