package zio.aws.iam.model
import zio.aws.iam.model.primitives.{ServiceSpecificCredentialId, UserNameType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteServiceSpecificCredentialRequest(
    userName: Option[UserNameType] = None,
    serviceSpecificCredentialId: ServiceSpecificCredentialId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.DeleteServiceSpecificCredentialRequest = {
    import DeleteServiceSpecificCredentialRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.DeleteServiceSpecificCredentialRequest
      .builder()
      .optionallyWith(
        userName.map(value => UserNameType.unwrap(value): java.lang.String)
      )(_.userName)
      .serviceSpecificCredentialId(
        ServiceSpecificCredentialId.unwrap(
          serviceSpecificCredentialId
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iam.model.DeleteServiceSpecificCredentialRequest.ReadOnly =
    zio.aws.iam.model.DeleteServiceSpecificCredentialRequest
      .wrap(buildAwsValue())
}
object DeleteServiceSpecificCredentialRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.DeleteServiceSpecificCredentialRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.DeleteServiceSpecificCredentialRequest =
      zio.aws.iam.model.DeleteServiceSpecificCredentialRequest(
        userName.map(value => value),
        serviceSpecificCredentialId
      )
    def userName: Option[UserNameType]
    def serviceSpecificCredentialId: ServiceSpecificCredentialId
    def getUserName: ZIO[Any, AwsError, UserNameType] =
      AwsError.unwrapOptionField("userName", userName)
    def getServiceSpecificCredentialId
        : ZIO[Any, Nothing, ServiceSpecificCredentialId] =
      ZIO.succeed(serviceSpecificCredentialId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.DeleteServiceSpecificCredentialRequest
  ) extends zio.aws.iam.model.DeleteServiceSpecificCredentialRequest.ReadOnly {
    override val userName: Option[UserNameType] = scala
      .Option(impl.userName())
      .map(value => zio.aws.iam.model.primitives.UserNameType(value))
    override val serviceSpecificCredentialId: ServiceSpecificCredentialId =
      zio.aws.iam.model.primitives
        .ServiceSpecificCredentialId(impl.serviceSpecificCredentialId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.DeleteServiceSpecificCredentialRequest
  ): zio.aws.iam.model.DeleteServiceSpecificCredentialRequest.ReadOnly =
    new Wrapper(impl)
}
