package zio.aws.iam.model
import zio.aws.iam.model.primitives.{CertificateIdType, ExistingUserNameType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteSigningCertificateRequest(
    userName: Option[ExistingUserNameType] = None,
    certificateId: CertificateIdType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.DeleteSigningCertificateRequest = {
    import DeleteSigningCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.DeleteSigningCertificateRequest
      .builder()
      .optionallyWith(
        userName.map(value =>
          ExistingUserNameType.unwrap(value): java.lang.String
        )
      )(_.userName)
      .certificateId(CertificateIdType.unwrap(certificateId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.DeleteSigningCertificateRequest.ReadOnly =
    zio.aws.iam.model.DeleteSigningCertificateRequest.wrap(buildAwsValue())
}
object DeleteSigningCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.DeleteSigningCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.DeleteSigningCertificateRequest =
      zio.aws.iam.model.DeleteSigningCertificateRequest(
        userName.map(value => value),
        certificateId
      )
    def userName: Option[ExistingUserNameType]
    def certificateId: CertificateIdType
    def getUserName: ZIO[Any, AwsError, ExistingUserNameType] =
      AwsError.unwrapOptionField("userName", userName)
    def getCertificateId: ZIO[Any, Nothing, CertificateIdType] =
      ZIO.succeed(certificateId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.DeleteSigningCertificateRequest
  ) extends zio.aws.iam.model.DeleteSigningCertificateRequest.ReadOnly {
    override val userName: Option[ExistingUserNameType] = scala
      .Option(impl.userName())
      .map(value => zio.aws.iam.model.primitives.ExistingUserNameType(value))
    override val certificateId: CertificateIdType =
      zio.aws.iam.model.primitives.CertificateIdType(impl.certificateId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.DeleteSigningCertificateRequest
  ): zio.aws.iam.model.DeleteSigningCertificateRequest.ReadOnly = new Wrapper(
    impl
  )
}
