package zio.aws.iam.model
import zio.aws.iam.model.primitives.UserNameType
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteUserPermissionsBoundaryRequest(userName: UserNameType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.DeleteUserPermissionsBoundaryRequest = {
    import DeleteUserPermissionsBoundaryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.DeleteUserPermissionsBoundaryRequest
      .builder()
      .userName(UserNameType.unwrap(userName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iam.model.DeleteUserPermissionsBoundaryRequest.ReadOnly =
    zio.aws.iam.model.DeleteUserPermissionsBoundaryRequest.wrap(buildAwsValue())
}
object DeleteUserPermissionsBoundaryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.DeleteUserPermissionsBoundaryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.DeleteUserPermissionsBoundaryRequest =
      zio.aws.iam.model.DeleteUserPermissionsBoundaryRequest(userName)
    def userName: UserNameType
    def getUserName: ZIO[Any, Nothing, UserNameType] = ZIO.succeed(userName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.DeleteUserPermissionsBoundaryRequest
  ) extends zio.aws.iam.model.DeleteUserPermissionsBoundaryRequest.ReadOnly {
    override val userName: UserNameType =
      zio.aws.iam.model.primitives.UserNameType(impl.userName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.DeleteUserPermissionsBoundaryRequest
  ): zio.aws.iam.model.DeleteUserPermissionsBoundaryRequest.ReadOnly =
    new Wrapper(impl)
}
