package zio.aws.iam.model
import zio.aws.iam.model.primitives.SerialNumberType
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteVirtualMfaDeviceRequest(serialNumber: SerialNumberType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.DeleteVirtualMfaDeviceRequest = {
    import DeleteVirtualMfaDeviceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.DeleteVirtualMfaDeviceRequest
      .builder()
      .serialNumber(SerialNumberType.unwrap(serialNumber): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.DeleteVirtualMfaDeviceRequest.ReadOnly =
    zio.aws.iam.model.DeleteVirtualMfaDeviceRequest.wrap(buildAwsValue())
}
object DeleteVirtualMfaDeviceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.DeleteVirtualMfaDeviceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.DeleteVirtualMfaDeviceRequest =
      zio.aws.iam.model.DeleteVirtualMfaDeviceRequest(serialNumber)
    def serialNumber: SerialNumberType
    def getSerialNumber: ZIO[Any, Nothing, SerialNumberType] =
      ZIO.succeed(serialNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.DeleteVirtualMfaDeviceRequest
  ) extends zio.aws.iam.model.DeleteVirtualMfaDeviceRequest.ReadOnly {
    override val serialNumber: SerialNumberType =
      zio.aws.iam.model.primitives.SerialNumberType(impl.serialNumber())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.DeleteVirtualMfaDeviceRequest
  ): zio.aws.iam.model.DeleteVirtualMfaDeviceRequest.ReadOnly = new Wrapper(
    impl
  )
}
