package zio.aws.iam.model
import zio.aws.iam.model.primitives.DateType
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class EntityDetails(
    entityInfo: zio.aws.iam.model.EntityInfo,
    lastAuthenticated: Option[DateType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.EntityDetails = {
    import EntityDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.EntityDetails
      .builder()
      .entityInfo(entityInfo.buildAwsValue())
      .optionallyWith(
        lastAuthenticated.map(value => DateType.unwrap(value): Instant)
      )(_.lastAuthenticated)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.EntityDetails.ReadOnly =
    zio.aws.iam.model.EntityDetails.wrap(buildAwsValue())
}
object EntityDetails {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iam.model.EntityDetails] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.EntityDetails =
      zio.aws.iam.model.EntityDetails(
        entityInfo.asEditable,
        lastAuthenticated.map(value => value)
      )
    def entityInfo: zio.aws.iam.model.EntityInfo.ReadOnly
    def lastAuthenticated: Option[DateType]
    def getEntityInfo
        : ZIO[Any, Nothing, zio.aws.iam.model.EntityInfo.ReadOnly] =
      ZIO.succeed(entityInfo)
    def getLastAuthenticated: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastAuthenticated", lastAuthenticated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.EntityDetails
  ) extends zio.aws.iam.model.EntityDetails.ReadOnly {
    override val entityInfo: zio.aws.iam.model.EntityInfo.ReadOnly =
      zio.aws.iam.model.EntityInfo.wrap(impl.entityInfo())
    override val lastAuthenticated: Option[DateType] = scala
      .Option(impl.lastAuthenticated())
      .map(value => zio.aws.iam.model.primitives.DateType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.EntityDetails
  ): zio.aws.iam.model.EntityDetails.ReadOnly = new Wrapper(impl)
}
