package zio.aws.iam.model
import scala.jdk.CollectionConverters.*
sealed trait EntityType {
  def unwrap: software.amazon.awssdk.services.iam.model.EntityType
}
object EntityType {
  def wrap(
      value: software.amazon.awssdk.services.iam.model.EntityType
  ): zio.aws.iam.model.EntityType = value match {
    case software.amazon.awssdk.services.iam.model.EntityType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iam.model.EntityType.USER =>
      val r = User
      r
    case software.amazon.awssdk.services.iam.model.EntityType.ROLE =>
      val r = Role
      r
    case software.amazon.awssdk.services.iam.model.EntityType.GROUP =>
      val r = Group
      r
    case software.amazon.awssdk.services.iam.model.EntityType.LOCAL_MANAGED_POLICY =>
      val r = LocalManagedPolicy
      r
    case software.amazon.awssdk.services.iam.model.EntityType.AWS_MANAGED_POLICY =>
      val r = AWSManagedPolicy
      r
  }
  case object unknownToSdkVersion extends zio.aws.iam.model.EntityType {
    override def unwrap: software.amazon.awssdk.services.iam.model.EntityType =
      software.amazon.awssdk.services.iam.model.EntityType.UNKNOWN_TO_SDK_VERSION
  }
  case object User extends zio.aws.iam.model.EntityType {
    override def unwrap: software.amazon.awssdk.services.iam.model.EntityType =
      software.amazon.awssdk.services.iam.model.EntityType.USER
  }
  case object Role extends zio.aws.iam.model.EntityType {
    override def unwrap: software.amazon.awssdk.services.iam.model.EntityType =
      software.amazon.awssdk.services.iam.model.EntityType.ROLE
  }
  case object Group extends zio.aws.iam.model.EntityType {
    override def unwrap: software.amazon.awssdk.services.iam.model.EntityType =
      software.amazon.awssdk.services.iam.model.EntityType.GROUP
  }
  case object LocalManagedPolicy extends zio.aws.iam.model.EntityType {
    override def unwrap: software.amazon.awssdk.services.iam.model.EntityType =
      software.amazon.awssdk.services.iam.model.EntityType.LOCAL_MANAGED_POLICY
  }
  case object AWSManagedPolicy extends zio.aws.iam.model.EntityType {
    override def unwrap: software.amazon.awssdk.services.iam.model.EntityType =
      software.amazon.awssdk.services.iam.model.EntityType.AWS_MANAGED_POLICY
  }
}
