package zio.aws.iam.model
import zio.aws.iam.model.primitives.StringType
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ErrorDetails(message: StringType, code: StringType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ErrorDetails = {
    import ErrorDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ErrorDetails
      .builder()
      .message(StringType.unwrap(message): java.lang.String)
      .code(StringType.unwrap(code): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.ErrorDetails.ReadOnly =
    zio.aws.iam.model.ErrorDetails.wrap(buildAwsValue())
}
object ErrorDetails {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iam.model.ErrorDetails] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ErrorDetails =
      zio.aws.iam.model.ErrorDetails(message, code)
    def message: StringType
    def code: StringType
    def getMessage: ZIO[Any, Nothing, StringType] = ZIO.succeed(message)
    def getCode: ZIO[Any, Nothing, StringType] = ZIO.succeed(code)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ErrorDetails
  ) extends zio.aws.iam.model.ErrorDetails.ReadOnly {
    override val message: StringType =
      zio.aws.iam.model.primitives.StringType(impl.message())
    override val code: StringType =
      zio.aws.iam.model.primitives.StringType(impl.code())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ErrorDetails
  ): zio.aws.iam.model.ErrorDetails.ReadOnly = new Wrapper(impl)
}
