package zio.aws.iam.model
import zio.aws.iam.model.primitives.{
  EvalDecisionSourceType,
  ContextKeyNameType,
  ResourceNameType,
  ActionNameType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class EvaluationResult(
    evalActionName: ActionNameType,
    evalResourceName: Option[ResourceNameType] = None,
    evalDecision: zio.aws.iam.model.PolicyEvaluationDecisionType,
    matchedStatements: Option[Iterable[zio.aws.iam.model.Statement]] = None,
    missingContextValues: Option[Iterable[ContextKeyNameType]] = None,
    organizationsDecisionDetail: Option[
      zio.aws.iam.model.OrganizationsDecisionDetail
    ] = None,
    permissionsBoundaryDecisionDetail: Option[
      zio.aws.iam.model.PermissionsBoundaryDecisionDetail
    ] = None,
    evalDecisionDetails: Option[Map[
      EvalDecisionSourceType,
      zio.aws.iam.model.PolicyEvaluationDecisionType
    ]] = None,
    resourceSpecificResults: Option[
      Iterable[zio.aws.iam.model.ResourceSpecificResult]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.EvaluationResult = {
    import EvaluationResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.EvaluationResult
      .builder()
      .evalActionName(ActionNameType.unwrap(evalActionName): java.lang.String)
      .optionallyWith(
        evalResourceName.map(value =>
          ResourceNameType.unwrap(value): java.lang.String
        )
      )(_.evalResourceName)
      .evalDecision(evalDecision.unwrap)
      .optionallyWith(
        matchedStatements.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.matchedStatements)
      .optionallyWith(
        missingContextValues.map(value =>
          value.map { item =>
            ContextKeyNameType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.missingContextValues)
      .optionallyWith(
        organizationsDecisionDetail.map(value => value.buildAwsValue())
      )(_.organizationsDecisionDetail)
      .optionallyWith(
        permissionsBoundaryDecisionDetail.map(value => value.buildAwsValue())
      )(_.permissionsBoundaryDecisionDetail)
      .optionallyWith(
        evalDecisionDetails.map(value =>
          value
            .map({ case (key, value) =>
              (EvalDecisionSourceType
                .unwrap(key): java.lang.String) -> value.unwrap.toString
            })
            .asJava
        )
      )(_.evalDecisionDetailsWithStrings)
      .optionallyWith(
        resourceSpecificResults.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceSpecificResults)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.EvaluationResult.ReadOnly =
    zio.aws.iam.model.EvaluationResult.wrap(buildAwsValue())
}
object EvaluationResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.EvaluationResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.EvaluationResult =
      zio.aws.iam.model.EvaluationResult(
        evalActionName,
        evalResourceName.map(value => value),
        evalDecision,
        matchedStatements.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        missingContextValues.map(value => value),
        organizationsDecisionDetail.map(value => value.asEditable),
        permissionsBoundaryDecisionDetail.map(value => value.asEditable),
        evalDecisionDetails.map(value => value),
        resourceSpecificResults.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def evalActionName: ActionNameType
    def evalResourceName: Option[ResourceNameType]
    def evalDecision: zio.aws.iam.model.PolicyEvaluationDecisionType
    def matchedStatements: Option[List[zio.aws.iam.model.Statement.ReadOnly]]
    def missingContextValues: Option[List[ContextKeyNameType]]
    def organizationsDecisionDetail
        : Option[zio.aws.iam.model.OrganizationsDecisionDetail.ReadOnly]
    def permissionsBoundaryDecisionDetail
        : Option[zio.aws.iam.model.PermissionsBoundaryDecisionDetail.ReadOnly]
    def evalDecisionDetails: Option[Map[
      EvalDecisionSourceType,
      zio.aws.iam.model.PolicyEvaluationDecisionType
    ]]
    def resourceSpecificResults
        : Option[List[zio.aws.iam.model.ResourceSpecificResult.ReadOnly]]
    def getEvalActionName: ZIO[Any, Nothing, ActionNameType] =
      ZIO.succeed(evalActionName)
    def getEvalResourceName: ZIO[Any, AwsError, ResourceNameType] =
      AwsError.unwrapOptionField("evalResourceName", evalResourceName)
    def getEvalDecision
        : ZIO[Any, Nothing, zio.aws.iam.model.PolicyEvaluationDecisionType] =
      ZIO.succeed(evalDecision)
    def getMatchedStatements
        : ZIO[Any, AwsError, List[zio.aws.iam.model.Statement.ReadOnly]] =
      AwsError.unwrapOptionField("matchedStatements", matchedStatements)
    def getMissingContextValues: ZIO[Any, AwsError, List[ContextKeyNameType]] =
      AwsError.unwrapOptionField("missingContextValues", missingContextValues)
    def getOrganizationsDecisionDetail: ZIO[
      Any,
      AwsError,
      zio.aws.iam.model.OrganizationsDecisionDetail.ReadOnly
    ] = AwsError.unwrapOptionField(
      "organizationsDecisionDetail",
      organizationsDecisionDetail
    )
    def getPermissionsBoundaryDecisionDetail: ZIO[
      Any,
      AwsError,
      zio.aws.iam.model.PermissionsBoundaryDecisionDetail.ReadOnly
    ] = AwsError.unwrapOptionField(
      "permissionsBoundaryDecisionDetail",
      permissionsBoundaryDecisionDetail
    )
    def getEvalDecisionDetails: ZIO[Any, AwsError, Map[
      EvalDecisionSourceType,
      zio.aws.iam.model.PolicyEvaluationDecisionType
    ]] = AwsError.unwrapOptionField("evalDecisionDetails", evalDecisionDetails)
    def getResourceSpecificResults: ZIO[Any, AwsError, List[
      zio.aws.iam.model.ResourceSpecificResult.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resourceSpecificResults",
      resourceSpecificResults
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.EvaluationResult
  ) extends zio.aws.iam.model.EvaluationResult.ReadOnly {
    override val evalActionName: ActionNameType =
      zio.aws.iam.model.primitives.ActionNameType(impl.evalActionName())
    override val evalResourceName: Option[ResourceNameType] = scala
      .Option(impl.evalResourceName())
      .map(value => zio.aws.iam.model.primitives.ResourceNameType(value))
    override val evalDecision: zio.aws.iam.model.PolicyEvaluationDecisionType =
      zio.aws.iam.model.PolicyEvaluationDecisionType.wrap(impl.evalDecision())
    override val matchedStatements
        : Option[List[zio.aws.iam.model.Statement.ReadOnly]] = scala
      .Option(impl.matchedStatements())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iam.model.Statement.wrap(item)
        }.toList
      )
    override val missingContextValues: Option[List[ContextKeyNameType]] = scala
      .Option(impl.missingContextValues())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iam.model.primitives.ContextKeyNameType(item)
        }.toList
      )
    override val organizationsDecisionDetail
        : Option[zio.aws.iam.model.OrganizationsDecisionDetail.ReadOnly] = scala
      .Option(impl.organizationsDecisionDetail())
      .map(value => zio.aws.iam.model.OrganizationsDecisionDetail.wrap(value))
    override val permissionsBoundaryDecisionDetail
        : Option[zio.aws.iam.model.PermissionsBoundaryDecisionDetail.ReadOnly] =
      scala
        .Option(impl.permissionsBoundaryDecisionDetail())
        .map(value =>
          zio.aws.iam.model.PermissionsBoundaryDecisionDetail.wrap(value)
        )
    override val evalDecisionDetails: Option[Map[
      EvalDecisionSourceType,
      zio.aws.iam.model.PolicyEvaluationDecisionType
    ]] = scala
      .Option(impl.evalDecisionDetails())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iam.model.primitives.EvalDecisionSourceType(
              key
            ) -> zio.aws.iam.model.PolicyEvaluationDecisionType.wrap(value)
          })
          .toMap
      )
    override val resourceSpecificResults
        : Option[List[zio.aws.iam.model.ResourceSpecificResult.ReadOnly]] =
      scala
        .Option(impl.resourceSpecificResults())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iam.model.ResourceSpecificResult.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.EvaluationResult
  ): zio.aws.iam.model.EvaluationResult.ReadOnly = new Wrapper(impl)
}
