package zio.aws.iam.model
import zio.aws.iam.model.primitives.{
  OrganizationsPolicyIdType,
  OrganizationsEntityPathType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GenerateOrganizationsAccessReportRequest(
    entityPath: OrganizationsEntityPathType,
    organizationsPolicyId: Option[OrganizationsPolicyIdType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GenerateOrganizationsAccessReportRequest = {
    import GenerateOrganizationsAccessReportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GenerateOrganizationsAccessReportRequest
      .builder()
      .entityPath(
        OrganizationsEntityPathType.unwrap(entityPath): java.lang.String
      )
      .optionallyWith(
        organizationsPolicyId.map(value =>
          OrganizationsPolicyIdType.unwrap(value): java.lang.String
        )
      )(_.organizationsPolicyId)
      .build()
  }
  def asReadOnly
      : zio.aws.iam.model.GenerateOrganizationsAccessReportRequest.ReadOnly =
    zio.aws.iam.model.GenerateOrganizationsAccessReportRequest
      .wrap(buildAwsValue())
}
object GenerateOrganizationsAccessReportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GenerateOrganizationsAccessReportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.GenerateOrganizationsAccessReportRequest =
      zio.aws.iam.model.GenerateOrganizationsAccessReportRequest(
        entityPath,
        organizationsPolicyId.map(value => value)
      )
    def entityPath: OrganizationsEntityPathType
    def organizationsPolicyId: Option[OrganizationsPolicyIdType]
    def getEntityPath: ZIO[Any, Nothing, OrganizationsEntityPathType] =
      ZIO.succeed(entityPath)
    def getOrganizationsPolicyId
        : ZIO[Any, AwsError, OrganizationsPolicyIdType] =
      AwsError.unwrapOptionField("organizationsPolicyId", organizationsPolicyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GenerateOrganizationsAccessReportRequest
  ) extends zio.aws.iam.model.GenerateOrganizationsAccessReportRequest.ReadOnly {
    override val entityPath: OrganizationsEntityPathType =
      zio.aws.iam.model.primitives
        .OrganizationsEntityPathType(impl.entityPath())
    override val organizationsPolicyId: Option[OrganizationsPolicyIdType] =
      scala
        .Option(impl.organizationsPolicyId())
        .map(value =>
          zio.aws.iam.model.primitives.OrganizationsPolicyIdType(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GenerateOrganizationsAccessReportRequest
  ): zio.aws.iam.model.GenerateOrganizationsAccessReportRequest.ReadOnly =
    new Wrapper(impl)
}
