package zio.aws.iam.model
import zio.aws.iam.model.primitives.JobIDType
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GenerateOrganizationsAccessReportResponse(
    jobId: Option[JobIDType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GenerateOrganizationsAccessReportResponse = {
    import GenerateOrganizationsAccessReportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GenerateOrganizationsAccessReportResponse
      .builder()
      .optionallyWith(
        jobId.map(value => JobIDType.unwrap(value): java.lang.String)
      )(_.jobId)
      .build()
  }
  def asReadOnly
      : zio.aws.iam.model.GenerateOrganizationsAccessReportResponse.ReadOnly =
    zio.aws.iam.model.GenerateOrganizationsAccessReportResponse
      .wrap(buildAwsValue())
}
object GenerateOrganizationsAccessReportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GenerateOrganizationsAccessReportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iam.model.GenerateOrganizationsAccessReportResponse =
      zio.aws.iam.model
        .GenerateOrganizationsAccessReportResponse(jobId.map(value => value))
    def jobId: Option[JobIDType]
    def getJobId: ZIO[Any, AwsError, JobIDType] =
      AwsError.unwrapOptionField("jobId", jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GenerateOrganizationsAccessReportResponse
  ) extends zio.aws.iam.model.GenerateOrganizationsAccessReportResponse.ReadOnly {
    override val jobId: Option[JobIDType] = scala
      .Option(impl.jobId())
      .map(value => zio.aws.iam.model.primitives.JobIDType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GenerateOrganizationsAccessReportResponse
  ): zio.aws.iam.model.GenerateOrganizationsAccessReportResponse.ReadOnly =
    new Wrapper(impl)
}
