package zio.aws.iam.model
import zio.aws.iam.model.primitives.ArnType
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GenerateServiceLastAccessedDetailsRequest(
    arn: ArnType,
    granularity: Option[zio.aws.iam.model.AccessAdvisorUsageGranularityType] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GenerateServiceLastAccessedDetailsRequest = {
    import GenerateServiceLastAccessedDetailsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GenerateServiceLastAccessedDetailsRequest
      .builder()
      .arn(ArnType.unwrap(arn): java.lang.String)
      .optionallyWith(granularity.map(value => value.unwrap))(_.granularity)
      .build()
  }
  def asReadOnly
      : zio.aws.iam.model.GenerateServiceLastAccessedDetailsRequest.ReadOnly =
    zio.aws.iam.model.GenerateServiceLastAccessedDetailsRequest
      .wrap(buildAwsValue())
}
object GenerateServiceLastAccessedDetailsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GenerateServiceLastAccessedDetailsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iam.model.GenerateServiceLastAccessedDetailsRequest =
      zio.aws.iam.model.GenerateServiceLastAccessedDetailsRequest(
        arn,
        granularity.map(value => value)
      )
    def arn: ArnType
    def granularity: Option[zio.aws.iam.model.AccessAdvisorUsageGranularityType]
    def getArn: ZIO[Any, Nothing, ArnType] = ZIO.succeed(arn)
    def getGranularity: ZIO[
      Any,
      AwsError,
      zio.aws.iam.model.AccessAdvisorUsageGranularityType
    ] = AwsError.unwrapOptionField("granularity", granularity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GenerateServiceLastAccessedDetailsRequest
  ) extends zio.aws.iam.model.GenerateServiceLastAccessedDetailsRequest.ReadOnly {
    override val arn: ArnType = zio.aws.iam.model.primitives.ArnType(impl.arn())
    override val granularity
        : Option[zio.aws.iam.model.AccessAdvisorUsageGranularityType] = scala
      .Option(impl.granularity())
      .map(value =>
        zio.aws.iam.model.AccessAdvisorUsageGranularityType.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GenerateServiceLastAccessedDetailsRequest
  ): zio.aws.iam.model.GenerateServiceLastAccessedDetailsRequest.ReadOnly =
    new Wrapper(impl)
}
