package zio.aws.iam.model
import java.lang.Integer
import zio.aws.iam.model.primitives.{MarkerType, MaxItemsType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetAccountAuthorizationDetailsRequest(
    filter: Option[Iterable[zio.aws.iam.model.EntityType]] = None,
    maxItems: Option[MaxItemsType] = None,
    marker: Option[MarkerType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsRequest = {
    import GetAccountAuthorizationDetailsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsRequest
      .builder()
      .optionallyWith(
        filter.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.filterWithStrings)
      .optionallyWith(
        maxItems.map(value => MaxItemsType.unwrap(value): Integer)
      )(_.maxItems)
      .optionallyWith(
        marker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.iam.model.GetAccountAuthorizationDetailsRequest.ReadOnly =
    zio.aws.iam.model.GetAccountAuthorizationDetailsRequest
      .wrap(buildAwsValue())
}
object GetAccountAuthorizationDetailsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.GetAccountAuthorizationDetailsRequest =
      zio.aws.iam.model.GetAccountAuthorizationDetailsRequest(
        filter.map(value => value),
        maxItems.map(value => value),
        marker.map(value => value)
      )
    def filter: Option[List[zio.aws.iam.model.EntityType]]
    def maxItems: Option[MaxItemsType]
    def marker: Option[MarkerType]
    def getFilter: ZIO[Any, AwsError, List[zio.aws.iam.model.EntityType]] =
      AwsError.unwrapOptionField("filter", filter)
    def getMaxItems: ZIO[Any, AwsError, MaxItemsType] =
      AwsError.unwrapOptionField("maxItems", maxItems)
    def getMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsRequest
  ) extends zio.aws.iam.model.GetAccountAuthorizationDetailsRequest.ReadOnly {
    override val filter: Option[List[zio.aws.iam.model.EntityType]] = scala
      .Option(impl.filter())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iam.model.EntityType.wrap(item)
        }.toList
      )
    override val maxItems: Option[MaxItemsType] = scala
      .Option(impl.maxItems())
      .map(value => zio.aws.iam.model.primitives.MaxItemsType(value))
    override val marker: Option[MarkerType] = scala
      .Option(impl.marker())
      .map(value => zio.aws.iam.model.primitives.MarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsRequest
  ): zio.aws.iam.model.GetAccountAuthorizationDetailsRequest.ReadOnly =
    new Wrapper(impl)
}
