package zio.aws.iam.model
import zio.aws.iam.model.primitives.ContextKeyNameType
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetContextKeysForCustomPolicyResponse(
    contextKeyNames: Option[Iterable[ContextKeyNameType]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GetContextKeysForCustomPolicyResponse = {
    import GetContextKeysForCustomPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GetContextKeysForCustomPolicyResponse
      .builder()
      .optionallyWith(
        contextKeyNames.map(value =>
          value.map { item =>
            ContextKeyNameType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.contextKeyNames)
      .build()
  }
  def asReadOnly
      : zio.aws.iam.model.GetContextKeysForCustomPolicyResponse.ReadOnly =
    zio.aws.iam.model.GetContextKeysForCustomPolicyResponse
      .wrap(buildAwsValue())
}
object GetContextKeysForCustomPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GetContextKeysForCustomPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.GetContextKeysForCustomPolicyResponse =
      zio.aws.iam.model.GetContextKeysForCustomPolicyResponse(
        contextKeyNames.map(value => value)
      )
    def contextKeyNames: Option[List[ContextKeyNameType]]
    def getContextKeyNames: ZIO[Any, AwsError, List[ContextKeyNameType]] =
      AwsError.unwrapOptionField("contextKeyNames", contextKeyNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GetContextKeysForCustomPolicyResponse
  ) extends zio.aws.iam.model.GetContextKeysForCustomPolicyResponse.ReadOnly {
    override val contextKeyNames: Option[List[ContextKeyNameType]] = scala
      .Option(impl.contextKeyNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iam.model.primitives.ContextKeyNameType(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GetContextKeysForCustomPolicyResponse
  ): zio.aws.iam.model.GetContextKeysForCustomPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
