package zio.aws.iam.model
import zio.aws.iam.model.primitives.{PolicyDocumentType, ArnType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetContextKeysForPrincipalPolicyRequest(
    policySourceArn: ArnType,
    policyInputList: Option[Iterable[PolicyDocumentType]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GetContextKeysForPrincipalPolicyRequest = {
    import GetContextKeysForPrincipalPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GetContextKeysForPrincipalPolicyRequest
      .builder()
      .policySourceArn(ArnType.unwrap(policySourceArn): java.lang.String)
      .optionallyWith(
        policyInputList.map(value =>
          value.map { item =>
            PolicyDocumentType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.policyInputList)
      .build()
  }
  def asReadOnly
      : zio.aws.iam.model.GetContextKeysForPrincipalPolicyRequest.ReadOnly =
    zio.aws.iam.model.GetContextKeysForPrincipalPolicyRequest
      .wrap(buildAwsValue())
}
object GetContextKeysForPrincipalPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GetContextKeysForPrincipalPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.GetContextKeysForPrincipalPolicyRequest =
      zio.aws.iam.model.GetContextKeysForPrincipalPolicyRequest(
        policySourceArn,
        policyInputList.map(value => value)
      )
    def policySourceArn: ArnType
    def policyInputList: Option[List[PolicyDocumentType]]
    def getPolicySourceArn: ZIO[Any, Nothing, ArnType] =
      ZIO.succeed(policySourceArn)
    def getPolicyInputList: ZIO[Any, AwsError, List[PolicyDocumentType]] =
      AwsError.unwrapOptionField("policyInputList", policyInputList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GetContextKeysForPrincipalPolicyRequest
  ) extends zio.aws.iam.model.GetContextKeysForPrincipalPolicyRequest.ReadOnly {
    override val policySourceArn: ArnType =
      zio.aws.iam.model.primitives.ArnType(impl.policySourceArn())
    override val policyInputList: Option[List[PolicyDocumentType]] = scala
      .Option(impl.policyInputList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iam.model.primitives.PolicyDocumentType(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GetContextKeysForPrincipalPolicyRequest
  ): zio.aws.iam.model.GetContextKeysForPrincipalPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
