package zio.aws.iam.model
import zio.aws.iam.model.primitives.{DateType, ReportContentType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class GetCredentialReportResponse(
    content: Option[ReportContentType] = None,
    reportFormat: Option[zio.aws.iam.model.ReportFormatType] = None,
    generatedTime: Option[DateType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GetCredentialReportResponse = {
    import GetCredentialReportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GetCredentialReportResponse
      .builder()
      .optionallyWith(
        content.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.content)
      .optionallyWith(reportFormat.map(value => value.unwrap))(_.reportFormat)
      .optionallyWith(
        generatedTime.map(value => DateType.unwrap(value): Instant)
      )(_.generatedTime)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.GetCredentialReportResponse.ReadOnly =
    zio.aws.iam.model.GetCredentialReportResponse.wrap(buildAwsValue())
}
object GetCredentialReportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GetCredentialReportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.GetCredentialReportResponse =
      zio.aws.iam.model.GetCredentialReportResponse(
        content.map(value => value),
        reportFormat.map(value => value),
        generatedTime.map(value => value)
      )
    def content: Option[ReportContentType]
    def reportFormat: Option[zio.aws.iam.model.ReportFormatType]
    def generatedTime: Option[DateType]
    def getContent: ZIO[Any, AwsError, ReportContentType] =
      AwsError.unwrapOptionField("content", content)
    def getReportFormat
        : ZIO[Any, AwsError, zio.aws.iam.model.ReportFormatType] =
      AwsError.unwrapOptionField("reportFormat", reportFormat)
    def getGeneratedTime: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("generatedTime", generatedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GetCredentialReportResponse
  ) extends zio.aws.iam.model.GetCredentialReportResponse.ReadOnly {
    override val content: Option[ReportContentType] = scala
      .Option(impl.content())
      .map(value =>
        zio.aws.iam.model.primitives
          .ReportContentType(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val reportFormat: Option[zio.aws.iam.model.ReportFormatType] =
      scala
        .Option(impl.reportFormat())
        .map(value => zio.aws.iam.model.ReportFormatType.wrap(value))
    override val generatedTime: Option[DateType] = scala
      .Option(impl.generatedTime())
      .map(value => zio.aws.iam.model.primitives.DateType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GetCredentialReportResponse
  ): zio.aws.iam.model.GetCredentialReportResponse.ReadOnly = new Wrapper(impl)
}
