package zio.aws.iam.model
import java.lang.Integer
import zio.aws.iam.model.primitives.{MaxItemsType, MarkerType, GroupNameType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetGroupRequest(
    groupName: GroupNameType,
    marker: Option[MarkerType] = None,
    maxItems: Option[MaxItemsType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GetGroupRequest = {
    import GetGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GetGroupRequest
      .builder()
      .groupName(GroupNameType.unwrap(groupName): java.lang.String)
      .optionallyWith(
        marker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        maxItems.map(value => MaxItemsType.unwrap(value): Integer)
      )(_.maxItems)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.GetGroupRequest.ReadOnly =
    zio.aws.iam.model.GetGroupRequest.wrap(buildAwsValue())
}
object GetGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GetGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.GetGroupRequest =
      zio.aws.iam.model.GetGroupRequest(
        groupName,
        marker.map(value => value),
        maxItems.map(value => value)
      )
    def groupName: GroupNameType
    def marker: Option[MarkerType]
    def maxItems: Option[MaxItemsType]
    def getGroupName: ZIO[Any, Nothing, GroupNameType] = ZIO.succeed(groupName)
    def getMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, MaxItemsType] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GetGroupRequest
  ) extends zio.aws.iam.model.GetGroupRequest.ReadOnly {
    override val groupName: GroupNameType =
      zio.aws.iam.model.primitives.GroupNameType(impl.groupName())
    override val marker: Option[MarkerType] = scala
      .Option(impl.marker())
      .map(value => zio.aws.iam.model.primitives.MarkerType(value))
    override val maxItems: Option[MaxItemsType] = scala
      .Option(impl.maxItems())
      .map(value => zio.aws.iam.model.primitives.MaxItemsType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GetGroupRequest
  ): zio.aws.iam.model.GetGroupRequest.ReadOnly = new Wrapper(impl)
}
