package zio.aws.iam.model
import java.lang.Integer
import zio.aws.iam.model.primitives.{MarkerType, MaxItemsType, JobIDType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetOrganizationsAccessReportRequest(
    jobId: JobIDType,
    maxItems: Option[MaxItemsType] = None,
    marker: Option[MarkerType] = None,
    sortKey: Option[zio.aws.iam.model.SortKeyType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GetOrganizationsAccessReportRequest = {
    import GetOrganizationsAccessReportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GetOrganizationsAccessReportRequest
      .builder()
      .jobId(JobIDType.unwrap(jobId): java.lang.String)
      .optionallyWith(
        maxItems.map(value => MaxItemsType.unwrap(value): Integer)
      )(_.maxItems)
      .optionallyWith(
        marker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(sortKey.map(value => value.unwrap))(_.sortKey)
      .build()
  }
  def asReadOnly
      : zio.aws.iam.model.GetOrganizationsAccessReportRequest.ReadOnly =
    zio.aws.iam.model.GetOrganizationsAccessReportRequest.wrap(buildAwsValue())
}
object GetOrganizationsAccessReportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GetOrganizationsAccessReportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.GetOrganizationsAccessReportRequest =
      zio.aws.iam.model.GetOrganizationsAccessReportRequest(
        jobId,
        maxItems.map(value => value),
        marker.map(value => value),
        sortKey.map(value => value)
      )
    def jobId: JobIDType
    def maxItems: Option[MaxItemsType]
    def marker: Option[MarkerType]
    def sortKey: Option[zio.aws.iam.model.SortKeyType]
    def getJobId: ZIO[Any, Nothing, JobIDType] = ZIO.succeed(jobId)
    def getMaxItems: ZIO[Any, AwsError, MaxItemsType] =
      AwsError.unwrapOptionField("maxItems", maxItems)
    def getMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("marker", marker)
    def getSortKey: ZIO[Any, AwsError, zio.aws.iam.model.SortKeyType] =
      AwsError.unwrapOptionField("sortKey", sortKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GetOrganizationsAccessReportRequest
  ) extends zio.aws.iam.model.GetOrganizationsAccessReportRequest.ReadOnly {
    override val jobId: JobIDType =
      zio.aws.iam.model.primitives.JobIDType(impl.jobId())
    override val maxItems: Option[MaxItemsType] = scala
      .Option(impl.maxItems())
      .map(value => zio.aws.iam.model.primitives.MaxItemsType(value))
    override val marker: Option[MarkerType] = scala
      .Option(impl.marker())
      .map(value => zio.aws.iam.model.primitives.MarkerType(value))
    override val sortKey: Option[zio.aws.iam.model.SortKeyType] = scala
      .Option(impl.sortKey())
      .map(value => zio.aws.iam.model.SortKeyType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GetOrganizationsAccessReportRequest
  ): zio.aws.iam.model.GetOrganizationsAccessReportRequest.ReadOnly =
    new Wrapper(impl)
}
