package zio.aws.iam.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iam.model.primitives.{
  MarkerType,
  BooleanType,
  IntegerType,
  DateType
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetOrganizationsAccessReportResponse(
    jobStatus: zio.aws.iam.model.JobStatusType,
    jobCreationDate: DateType,
    jobCompletionDate: Option[DateType] = None,
    numberOfServicesAccessible: Option[IntegerType] = None,
    numberOfServicesNotAccessed: Option[IntegerType] = None,
    accessDetails: Option[Iterable[zio.aws.iam.model.AccessDetail]] = None,
    isTruncated: Option[BooleanType] = None,
    marker: Option[MarkerType] = None,
    errorDetails: Option[zio.aws.iam.model.ErrorDetails] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GetOrganizationsAccessReportResponse = {
    import GetOrganizationsAccessReportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GetOrganizationsAccessReportResponse
      .builder()
      .jobStatus(jobStatus.unwrap)
      .jobCreationDate(DateType.unwrap(jobCreationDate): Instant)
      .optionallyWith(
        jobCompletionDate.map(value => DateType.unwrap(value): Instant)
      )(_.jobCompletionDate)
      .optionallyWith(
        numberOfServicesAccessible.map(value =>
          IntegerType.unwrap(value): Integer
        )
      )(_.numberOfServicesAccessible)
      .optionallyWith(
        numberOfServicesNotAccessed.map(value =>
          IntegerType.unwrap(value): Integer
        )
      )(_.numberOfServicesNotAccessed)
      .optionallyWith(
        accessDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accessDetails)
      .optionallyWith(
        isTruncated.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.isTruncated)
      .optionallyWith(
        marker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(errorDetails.map(value => value.buildAwsValue()))(
        _.errorDetails
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iam.model.GetOrganizationsAccessReportResponse.ReadOnly =
    zio.aws.iam.model.GetOrganizationsAccessReportResponse.wrap(buildAwsValue())
}
object GetOrganizationsAccessReportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GetOrganizationsAccessReportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.GetOrganizationsAccessReportResponse =
      zio.aws.iam.model.GetOrganizationsAccessReportResponse(
        jobStatus,
        jobCreationDate,
        jobCompletionDate.map(value => value),
        numberOfServicesAccessible.map(value => value),
        numberOfServicesNotAccessed.map(value => value),
        accessDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        isTruncated.map(value => value),
        marker.map(value => value),
        errorDetails.map(value => value.asEditable)
      )
    def jobStatus: zio.aws.iam.model.JobStatusType
    def jobCreationDate: DateType
    def jobCompletionDate: Option[DateType]
    def numberOfServicesAccessible: Option[IntegerType]
    def numberOfServicesNotAccessed: Option[IntegerType]
    def accessDetails: Option[List[zio.aws.iam.model.AccessDetail.ReadOnly]]
    def isTruncated: Option[BooleanType]
    def marker: Option[MarkerType]
    def errorDetails: Option[zio.aws.iam.model.ErrorDetails.ReadOnly]
    def getJobStatus: ZIO[Any, Nothing, zio.aws.iam.model.JobStatusType] =
      ZIO.succeed(jobStatus)
    def getJobCreationDate: ZIO[Any, Nothing, DateType] =
      ZIO.succeed(jobCreationDate)
    def getJobCompletionDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("jobCompletionDate", jobCompletionDate)
    def getNumberOfServicesAccessible: ZIO[Any, AwsError, IntegerType] =
      AwsError.unwrapOptionField(
        "numberOfServicesAccessible",
        numberOfServicesAccessible
      )
    def getNumberOfServicesNotAccessed: ZIO[Any, AwsError, IntegerType] =
      AwsError.unwrapOptionField(
        "numberOfServicesNotAccessed",
        numberOfServicesNotAccessed
      )
    def getAccessDetails
        : ZIO[Any, AwsError, List[zio.aws.iam.model.AccessDetail.ReadOnly]] =
      AwsError.unwrapOptionField("accessDetails", accessDetails)
    def getIsTruncated: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("isTruncated", isTruncated)
    def getMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("marker", marker)
    def getErrorDetails
        : ZIO[Any, AwsError, zio.aws.iam.model.ErrorDetails.ReadOnly] =
      AwsError.unwrapOptionField("errorDetails", errorDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GetOrganizationsAccessReportResponse
  ) extends zio.aws.iam.model.GetOrganizationsAccessReportResponse.ReadOnly {
    override val jobStatus: zio.aws.iam.model.JobStatusType =
      zio.aws.iam.model.JobStatusType.wrap(impl.jobStatus())
    override val jobCreationDate: DateType =
      zio.aws.iam.model.primitives.DateType(impl.jobCreationDate())
    override val jobCompletionDate: Option[DateType] = scala
      .Option(impl.jobCompletionDate())
      .map(value => zio.aws.iam.model.primitives.DateType(value))
    override val numberOfServicesAccessible: Option[IntegerType] = scala
      .Option(impl.numberOfServicesAccessible())
      .map(value => zio.aws.iam.model.primitives.IntegerType(value))
    override val numberOfServicesNotAccessed: Option[IntegerType] = scala
      .Option(impl.numberOfServicesNotAccessed())
      .map(value => zio.aws.iam.model.primitives.IntegerType(value))
    override val accessDetails
        : Option[List[zio.aws.iam.model.AccessDetail.ReadOnly]] = scala
      .Option(impl.accessDetails())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iam.model.AccessDetail.wrap(item)
        }.toList
      )
    override val isTruncated: Option[BooleanType] = scala
      .Option(impl.isTruncated())
      .map(value => zio.aws.iam.model.primitives.BooleanType(value))
    override val marker: Option[MarkerType] = scala
      .Option(impl.marker())
      .map(value => zio.aws.iam.model.primitives.MarkerType(value))
    override val errorDetails: Option[zio.aws.iam.model.ErrorDetails.ReadOnly] =
      scala
        .Option(impl.errorDetails())
        .map(value => zio.aws.iam.model.ErrorDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GetOrganizationsAccessReportResponse
  ): zio.aws.iam.model.GetOrganizationsAccessReportResponse.ReadOnly =
    new Wrapper(impl)
}
