package zio.aws.iam.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetPolicyResponse(
    policy: Option[zio.aws.iam.model.Policy] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GetPolicyResponse = {
    import GetPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GetPolicyResponse
      .builder()
      .optionallyWith(policy.map(value => value.buildAwsValue()))(_.policy)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.GetPolicyResponse.ReadOnly =
    zio.aws.iam.model.GetPolicyResponse.wrap(buildAwsValue())
}
object GetPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GetPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.GetPolicyResponse =
      zio.aws.iam.model.GetPolicyResponse(policy.map(value => value.asEditable))
    def policy: Option[zio.aws.iam.model.Policy.ReadOnly]
    def getPolicy: ZIO[Any, AwsError, zio.aws.iam.model.Policy.ReadOnly] =
      AwsError.unwrapOptionField("policy", policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GetPolicyResponse
  ) extends zio.aws.iam.model.GetPolicyResponse.ReadOnly {
    override val policy: Option[zio.aws.iam.model.Policy.ReadOnly] = scala
      .Option(impl.policy())
      .map(value => zio.aws.iam.model.Policy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GetPolicyResponse
  ): zio.aws.iam.model.GetPolicyResponse.ReadOnly = new Wrapper(impl)
}
