package zio.aws.iam.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetPolicyVersionResponse(
    policyVersion: Option[zio.aws.iam.model.PolicyVersion] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GetPolicyVersionResponse = {
    import GetPolicyVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GetPolicyVersionResponse
      .builder()
      .optionallyWith(policyVersion.map(value => value.buildAwsValue()))(
        _.policyVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.iam.model.GetPolicyVersionResponse.ReadOnly =
    zio.aws.iam.model.GetPolicyVersionResponse.wrap(buildAwsValue())
}
object GetPolicyVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GetPolicyVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.GetPolicyVersionResponse =
      zio.aws.iam.model
        .GetPolicyVersionResponse(policyVersion.map(value => value.asEditable))
    def policyVersion: Option[zio.aws.iam.model.PolicyVersion.ReadOnly]
    def getPolicyVersion
        : ZIO[Any, AwsError, zio.aws.iam.model.PolicyVersion.ReadOnly] =
      AwsError.unwrapOptionField("policyVersion", policyVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GetPolicyVersionResponse
  ) extends zio.aws.iam.model.GetPolicyVersionResponse.ReadOnly {
    override val policyVersion
        : Option[zio.aws.iam.model.PolicyVersion.ReadOnly] = scala
      .Option(impl.policyVersion())
      .map(value => zio.aws.iam.model.PolicyVersion.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GetPolicyVersionResponse
  ): zio.aws.iam.model.GetPolicyVersionResponse.ReadOnly = new Wrapper(impl)
}
