package zio.aws.iam.model
import zio.aws.iam.model.primitives.ArnType
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetSamlProviderRequest(samlProviderArn: ArnType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GetSamlProviderRequest = {
    import GetSamlProviderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GetSamlProviderRequest
      .builder()
      .samlProviderArn(ArnType.unwrap(samlProviderArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.GetSamlProviderRequest.ReadOnly =
    zio.aws.iam.model.GetSamlProviderRequest.wrap(buildAwsValue())
}
object GetSamlProviderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GetSamlProviderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.GetSamlProviderRequest =
      zio.aws.iam.model.GetSamlProviderRequest(samlProviderArn)
    def samlProviderArn: ArnType
    def getSamlProviderArn: ZIO[Any, Nothing, ArnType] =
      ZIO.succeed(samlProviderArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GetSamlProviderRequest
  ) extends zio.aws.iam.model.GetSamlProviderRequest.ReadOnly {
    override val samlProviderArn: ArnType =
      zio.aws.iam.model.primitives.ArnType(impl.samlProviderArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GetSamlProviderRequest
  ): zio.aws.iam.model.GetSamlProviderRequest.ReadOnly = new Wrapper(impl)
}
