package zio.aws.iam.model
import zio.aws.iam.model.primitives.{DateType, SAMLMetadataDocumentType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class GetSamlProviderResponse(
    samlMetadataDocument: Option[SAMLMetadataDocumentType] = None,
    createDate: Option[DateType] = None,
    validUntil: Option[DateType] = None,
    tags: Option[Iterable[zio.aws.iam.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GetSamlProviderResponse = {
    import GetSamlProviderResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GetSamlProviderResponse
      .builder()
      .optionallyWith(
        samlMetadataDocument.map(value =>
          SAMLMetadataDocumentType.unwrap(value): java.lang.String
        )
      )(_.samlMetadataDocument)
      .optionallyWith(createDate.map(value => DateType.unwrap(value): Instant))(
        _.createDate
      )
      .optionallyWith(validUntil.map(value => DateType.unwrap(value): Instant))(
        _.validUntil
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.GetSamlProviderResponse.ReadOnly =
    zio.aws.iam.model.GetSamlProviderResponse.wrap(buildAwsValue())
}
object GetSamlProviderResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GetSamlProviderResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.GetSamlProviderResponse =
      zio.aws.iam.model.GetSamlProviderResponse(
        samlMetadataDocument.map(value => value),
        createDate.map(value => value),
        validUntil.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def samlMetadataDocument: Option[SAMLMetadataDocumentType]
    def createDate: Option[DateType]
    def validUntil: Option[DateType]
    def tags: Option[List[zio.aws.iam.model.Tag.ReadOnly]]
    def getSamlMetadataDocument: ZIO[Any, AwsError, SAMLMetadataDocumentType] =
      AwsError.unwrapOptionField("samlMetadataDocument", samlMetadataDocument)
    def getCreateDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("createDate", createDate)
    def getValidUntil: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("validUntil", validUntil)
    def getTags: ZIO[Any, AwsError, List[zio.aws.iam.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GetSamlProviderResponse
  ) extends zio.aws.iam.model.GetSamlProviderResponse.ReadOnly {
    override val samlMetadataDocument: Option[SAMLMetadataDocumentType] = scala
      .Option(impl.samlMetadataDocument())
      .map(value =>
        zio.aws.iam.model.primitives.SAMLMetadataDocumentType(value)
      )
    override val createDate: Option[DateType] = scala
      .Option(impl.createDate())
      .map(value => zio.aws.iam.model.primitives.DateType(value))
    override val validUntil: Option[DateType] = scala
      .Option(impl.validUntil())
      .map(value => zio.aws.iam.model.primitives.DateType(value))
    override val tags: Option[List[zio.aws.iam.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iam.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GetSamlProviderResponse
  ): zio.aws.iam.model.GetSamlProviderResponse.ReadOnly = new Wrapper(impl)
}
