package zio.aws.iam.model
import java.lang.Integer
import zio.aws.iam.model.primitives.{MarkerType, MaxItemsType, JobIDType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetServiceLastAccessedDetailsRequest(
    jobId: JobIDType,
    maxItems: Option[MaxItemsType] = None,
    marker: Option[MarkerType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GetServiceLastAccessedDetailsRequest = {
    import GetServiceLastAccessedDetailsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GetServiceLastAccessedDetailsRequest
      .builder()
      .jobId(JobIDType.unwrap(jobId): java.lang.String)
      .optionallyWith(
        maxItems.map(value => MaxItemsType.unwrap(value): Integer)
      )(_.maxItems)
      .optionallyWith(
        marker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.iam.model.GetServiceLastAccessedDetailsRequest.ReadOnly =
    zio.aws.iam.model.GetServiceLastAccessedDetailsRequest.wrap(buildAwsValue())
}
object GetServiceLastAccessedDetailsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GetServiceLastAccessedDetailsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.GetServiceLastAccessedDetailsRequest =
      zio.aws.iam.model.GetServiceLastAccessedDetailsRequest(
        jobId,
        maxItems.map(value => value),
        marker.map(value => value)
      )
    def jobId: JobIDType
    def maxItems: Option[MaxItemsType]
    def marker: Option[MarkerType]
    def getJobId: ZIO[Any, Nothing, JobIDType] = ZIO.succeed(jobId)
    def getMaxItems: ZIO[Any, AwsError, MaxItemsType] =
      AwsError.unwrapOptionField("maxItems", maxItems)
    def getMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GetServiceLastAccessedDetailsRequest
  ) extends zio.aws.iam.model.GetServiceLastAccessedDetailsRequest.ReadOnly {
    override val jobId: JobIDType =
      zio.aws.iam.model.primitives.JobIDType(impl.jobId())
    override val maxItems: Option[MaxItemsType] = scala
      .Option(impl.maxItems())
      .map(value => zio.aws.iam.model.primitives.MaxItemsType(value))
    override val marker: Option[MarkerType] = scala
      .Option(impl.marker())
      .map(value => zio.aws.iam.model.primitives.MarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GetServiceLastAccessedDetailsRequest
  ): zio.aws.iam.model.GetServiceLastAccessedDetailsRequest.ReadOnly =
    new Wrapper(impl)
}
