package zio.aws.iam.model
import zio.aws.iam.model.primitives.{ResponseMarkerType, BooleanType, DateType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class GetServiceLastAccessedDetailsWithEntitiesResponse(
    jobStatus: zio.aws.iam.model.JobStatusType,
    jobCreationDate: DateType,
    jobCompletionDate: DateType,
    entityDetailsList: Iterable[zio.aws.iam.model.EntityDetails],
    isTruncated: Option[BooleanType] = None,
    marker: Option[ResponseMarkerType] = None,
    error: Option[zio.aws.iam.model.ErrorDetails] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GetServiceLastAccessedDetailsWithEntitiesResponse = {
    import GetServiceLastAccessedDetailsWithEntitiesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GetServiceLastAccessedDetailsWithEntitiesResponse
      .builder()
      .jobStatus(jobStatus.unwrap)
      .jobCreationDate(DateType.unwrap(jobCreationDate): Instant)
      .jobCompletionDate(DateType.unwrap(jobCompletionDate): Instant)
      .entityDetailsList(entityDetailsList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        isTruncated.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.isTruncated)
      .optionallyWith(
        marker.map(value => ResponseMarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(error.map(value => value.buildAwsValue()))(_.error)
      .build()
  }
  def asReadOnly
      : zio.aws.iam.model.GetServiceLastAccessedDetailsWithEntitiesResponse.ReadOnly =
    zio.aws.iam.model.GetServiceLastAccessedDetailsWithEntitiesResponse
      .wrap(buildAwsValue())
}
object GetServiceLastAccessedDetailsWithEntitiesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GetServiceLastAccessedDetailsWithEntitiesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iam.model.GetServiceLastAccessedDetailsWithEntitiesResponse =
      zio.aws.iam.model.GetServiceLastAccessedDetailsWithEntitiesResponse(
        jobStatus,
        jobCreationDate,
        jobCompletionDate,
        entityDetailsList.map { item =>
          item.asEditable
        },
        isTruncated.map(value => value),
        marker.map(value => value),
        error.map(value => value.asEditable)
      )
    def jobStatus: zio.aws.iam.model.JobStatusType
    def jobCreationDate: DateType
    def jobCompletionDate: DateType
    def entityDetailsList: List[zio.aws.iam.model.EntityDetails.ReadOnly]
    def isTruncated: Option[BooleanType]
    def marker: Option[ResponseMarkerType]
    def error: Option[zio.aws.iam.model.ErrorDetails.ReadOnly]
    def getJobStatus: ZIO[Any, Nothing, zio.aws.iam.model.JobStatusType] =
      ZIO.succeed(jobStatus)
    def getJobCreationDate: ZIO[Any, Nothing, DateType] =
      ZIO.succeed(jobCreationDate)
    def getJobCompletionDate: ZIO[Any, Nothing, DateType] =
      ZIO.succeed(jobCompletionDate)
    def getEntityDetailsList
        : ZIO[Any, Nothing, List[zio.aws.iam.model.EntityDetails.ReadOnly]] =
      ZIO.succeed(entityDetailsList)
    def getIsTruncated: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("isTruncated", isTruncated)
    def getMarker: ZIO[Any, AwsError, ResponseMarkerType] =
      AwsError.unwrapOptionField("marker", marker)
    def getError: ZIO[Any, AwsError, zio.aws.iam.model.ErrorDetails.ReadOnly] =
      AwsError.unwrapOptionField("error", error)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GetServiceLastAccessedDetailsWithEntitiesResponse
  ) extends zio.aws.iam.model.GetServiceLastAccessedDetailsWithEntitiesResponse.ReadOnly {
    override val jobStatus: zio.aws.iam.model.JobStatusType =
      zio.aws.iam.model.JobStatusType.wrap(impl.jobStatus())
    override val jobCreationDate: DateType =
      zio.aws.iam.model.primitives.DateType(impl.jobCreationDate())
    override val jobCompletionDate: DateType =
      zio.aws.iam.model.primitives.DateType(impl.jobCompletionDate())
    override val entityDetailsList
        : List[zio.aws.iam.model.EntityDetails.ReadOnly] = impl
      .entityDetailsList()
      .asScala
      .map { item =>
        zio.aws.iam.model.EntityDetails.wrap(item)
      }
      .toList
    override val isTruncated: Option[BooleanType] = scala
      .Option(impl.isTruncated())
      .map(value => zio.aws.iam.model.primitives.BooleanType(value))
    override val marker: Option[ResponseMarkerType] = scala
      .Option(impl.marker())
      .map(value => zio.aws.iam.model.primitives.ResponseMarkerType(value))
    override val error: Option[zio.aws.iam.model.ErrorDetails.ReadOnly] = scala
      .Option(impl.error())
      .map(value => zio.aws.iam.model.ErrorDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GetServiceLastAccessedDetailsWithEntitiesResponse
  ): zio.aws.iam.model.GetServiceLastAccessedDetailsWithEntitiesResponse.ReadOnly =
    new Wrapper(impl)
}
