package zio.aws.iam.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetServiceLinkedRoleDeletionStatusResponse(
    status: zio.aws.iam.model.DeletionTaskStatusType,
    reason: Option[zio.aws.iam.model.DeletionTaskFailureReasonType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GetServiceLinkedRoleDeletionStatusResponse = {
    import GetServiceLinkedRoleDeletionStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GetServiceLinkedRoleDeletionStatusResponse
      .builder()
      .status(status.unwrap)
      .optionallyWith(reason.map(value => value.buildAwsValue()))(_.reason)
      .build()
  }
  def asReadOnly
      : zio.aws.iam.model.GetServiceLinkedRoleDeletionStatusResponse.ReadOnly =
    zio.aws.iam.model.GetServiceLinkedRoleDeletionStatusResponse
      .wrap(buildAwsValue())
}
object GetServiceLinkedRoleDeletionStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GetServiceLinkedRoleDeletionStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iam.model.GetServiceLinkedRoleDeletionStatusResponse =
      zio.aws.iam.model.GetServiceLinkedRoleDeletionStatusResponse(
        status,
        reason.map(value => value.asEditable)
      )
    def status: zio.aws.iam.model.DeletionTaskStatusType
    def reason: Option[zio.aws.iam.model.DeletionTaskFailureReasonType.ReadOnly]
    def getStatus: ZIO[Any, Nothing, zio.aws.iam.model.DeletionTaskStatusType] =
      ZIO.succeed(status)
    def getReason: ZIO[
      Any,
      AwsError,
      zio.aws.iam.model.DeletionTaskFailureReasonType.ReadOnly
    ] = AwsError.unwrapOptionField("reason", reason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GetServiceLinkedRoleDeletionStatusResponse
  ) extends zio.aws.iam.model.GetServiceLinkedRoleDeletionStatusResponse.ReadOnly {
    override val status: zio.aws.iam.model.DeletionTaskStatusType =
      zio.aws.iam.model.DeletionTaskStatusType.wrap(impl.status())
    override val reason
        : Option[zio.aws.iam.model.DeletionTaskFailureReasonType.ReadOnly] =
      scala
        .Option(impl.reason())
        .map(value =>
          zio.aws.iam.model.DeletionTaskFailureReasonType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GetServiceLinkedRoleDeletionStatusResponse
  ): zio.aws.iam.model.GetServiceLinkedRoleDeletionStatusResponse.ReadOnly =
    new Wrapper(impl)
}
