package zio.aws.iam.model
import zio.aws.iam.model.primitives.{
  ArnType,
  IdType,
  DateType,
  GroupNameType,
  PathType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class GroupDetail(
    path: Option[PathType] = None,
    groupName: Option[GroupNameType] = None,
    groupId: Option[IdType] = None,
    arn: Option[ArnType] = None,
    createDate: Option[DateType] = None,
    groupPolicyList: Option[Iterable[zio.aws.iam.model.PolicyDetail]] = None,
    attachedManagedPolicies: Option[
      Iterable[zio.aws.iam.model.AttachedPolicy]
    ] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.iam.model.GroupDetail = {
    import GroupDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GroupDetail
      .builder()
      .optionallyWith(
        path.map(value => PathType.unwrap(value): java.lang.String)
      )(_.path)
      .optionallyWith(
        groupName.map(value => GroupNameType.unwrap(value): java.lang.String)
      )(_.groupName)
      .optionallyWith(
        groupId.map(value => IdType.unwrap(value): java.lang.String)
      )(_.groupId)
      .optionallyWith(
        arn.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(createDate.map(value => DateType.unwrap(value): Instant))(
        _.createDate
      )
      .optionallyWith(
        groupPolicyList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.groupPolicyList)
      .optionallyWith(
        attachedManagedPolicies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attachedManagedPolicies)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.GroupDetail.ReadOnly =
    zio.aws.iam.model.GroupDetail.wrap(buildAwsValue())
}
object GroupDetail {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iam.model.GroupDetail] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.GroupDetail =
      zio.aws.iam.model.GroupDetail(
        path.map(value => value),
        groupName.map(value => value),
        groupId.map(value => value),
        arn.map(value => value),
        createDate.map(value => value),
        groupPolicyList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        attachedManagedPolicies.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def path: Option[PathType]
    def groupName: Option[GroupNameType]
    def groupId: Option[IdType]
    def arn: Option[ArnType]
    def createDate: Option[DateType]
    def groupPolicyList: Option[List[zio.aws.iam.model.PolicyDetail.ReadOnly]]
    def attachedManagedPolicies
        : Option[List[zio.aws.iam.model.AttachedPolicy.ReadOnly]]
    def getPath: ZIO[Any, AwsError, PathType] =
      AwsError.unwrapOptionField("path", path)
    def getGroupName: ZIO[Any, AwsError, GroupNameType] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getGroupId: ZIO[Any, AwsError, IdType] =
      AwsError.unwrapOptionField("groupId", groupId)
    def getArn: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreateDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("createDate", createDate)
    def getGroupPolicyList
        : ZIO[Any, AwsError, List[zio.aws.iam.model.PolicyDetail.ReadOnly]] =
      AwsError.unwrapOptionField("groupPolicyList", groupPolicyList)
    def getAttachedManagedPolicies
        : ZIO[Any, AwsError, List[zio.aws.iam.model.AttachedPolicy.ReadOnly]] =
      AwsError.unwrapOptionField(
        "attachedManagedPolicies",
        attachedManagedPolicies
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GroupDetail
  ) extends zio.aws.iam.model.GroupDetail.ReadOnly {
    override val path: Option[PathType] = scala
      .Option(impl.path())
      .map(value => zio.aws.iam.model.primitives.PathType(value))
    override val groupName: Option[GroupNameType] = scala
      .Option(impl.groupName())
      .map(value => zio.aws.iam.model.primitives.GroupNameType(value))
    override val groupId: Option[IdType] = scala
      .Option(impl.groupId())
      .map(value => zio.aws.iam.model.primitives.IdType(value))
    override val arn: Option[ArnType] = scala
      .Option(impl.arn())
      .map(value => zio.aws.iam.model.primitives.ArnType(value))
    override val createDate: Option[DateType] = scala
      .Option(impl.createDate())
      .map(value => zio.aws.iam.model.primitives.DateType(value))
    override val groupPolicyList
        : Option[List[zio.aws.iam.model.PolicyDetail.ReadOnly]] = scala
      .Option(impl.groupPolicyList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iam.model.PolicyDetail.wrap(item)
        }.toList
      )
    override val attachedManagedPolicies
        : Option[List[zio.aws.iam.model.AttachedPolicy.ReadOnly]] = scala
      .Option(impl.attachedManagedPolicies())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iam.model.AttachedPolicy.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GroupDetail
  ): zio.aws.iam.model.GroupDetail.ReadOnly = new Wrapper(impl)
}
