package zio.aws.iam.model
import scala.jdk.CollectionConverters.*
sealed trait JobStatusType {
  def unwrap: software.amazon.awssdk.services.iam.model.JobStatusType
}
object JobStatusType {
  def wrap(
      value: software.amazon.awssdk.services.iam.model.JobStatusType
  ): zio.aws.iam.model.JobStatusType = value match {
    case software.amazon.awssdk.services.iam.model.JobStatusType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iam.model.JobStatusType.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.iam.model.JobStatusType.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.iam.model.JobStatusType.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion extends zio.aws.iam.model.JobStatusType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.JobStatusType =
      software.amazon.awssdk.services.iam.model.JobStatusType.UNKNOWN_TO_SDK_VERSION
  }
  case object IN_PROGRESS extends zio.aws.iam.model.JobStatusType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.JobStatusType =
      software.amazon.awssdk.services.iam.model.JobStatusType.IN_PROGRESS
  }
  case object COMPLETED extends zio.aws.iam.model.JobStatusType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.JobStatusType =
      software.amazon.awssdk.services.iam.model.JobStatusType.COMPLETED
  }
  case object FAILED extends zio.aws.iam.model.JobStatusType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.JobStatusType =
      software.amazon.awssdk.services.iam.model.JobStatusType.FAILED
  }
}
