package zio.aws.iam.model
import java.lang.Integer
import zio.aws.iam.model.primitives.{
  MaxItemsType,
  MarkerType,
  ExistingUserNameType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListAccessKeysRequest(
    userName: Option[ExistingUserNameType] = None,
    marker: Option[MarkerType] = None,
    maxItems: Option[MaxItemsType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ListAccessKeysRequest = {
    import ListAccessKeysRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ListAccessKeysRequest
      .builder()
      .optionallyWith(
        userName.map(value =>
          ExistingUserNameType.unwrap(value): java.lang.String
        )
      )(_.userName)
      .optionallyWith(
        marker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        maxItems.map(value => MaxItemsType.unwrap(value): Integer)
      )(_.maxItems)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.ListAccessKeysRequest.ReadOnly =
    zio.aws.iam.model.ListAccessKeysRequest.wrap(buildAwsValue())
}
object ListAccessKeysRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ListAccessKeysRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ListAccessKeysRequest =
      zio.aws.iam.model.ListAccessKeysRequest(
        userName.map(value => value),
        marker.map(value => value),
        maxItems.map(value => value)
      )
    def userName: Option[ExistingUserNameType]
    def marker: Option[MarkerType]
    def maxItems: Option[MaxItemsType]
    def getUserName: ZIO[Any, AwsError, ExistingUserNameType] =
      AwsError.unwrapOptionField("userName", userName)
    def getMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, MaxItemsType] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ListAccessKeysRequest
  ) extends zio.aws.iam.model.ListAccessKeysRequest.ReadOnly {
    override val userName: Option[ExistingUserNameType] = scala
      .Option(impl.userName())
      .map(value => zio.aws.iam.model.primitives.ExistingUserNameType(value))
    override val marker: Option[MarkerType] = scala
      .Option(impl.marker())
      .map(value => zio.aws.iam.model.primitives.MarkerType(value))
    override val maxItems: Option[MaxItemsType] = scala
      .Option(impl.maxItems())
      .map(value => zio.aws.iam.model.primitives.MaxItemsType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ListAccessKeysRequest
  ): zio.aws.iam.model.ListAccessKeysRequest.ReadOnly = new Wrapper(impl)
}
