package zio.aws.iam.model
import zio.aws.iam.model.primitives.{ResponseMarkerType, BooleanType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListAccessKeysResponse(
    accessKeyMetadata: Iterable[zio.aws.iam.model.AccessKeyMetadata],
    isTruncated: Option[BooleanType] = None,
    marker: Option[ResponseMarkerType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ListAccessKeysResponse = {
    import ListAccessKeysResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ListAccessKeysResponse
      .builder()
      .accessKeyMetadata(accessKeyMetadata.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        isTruncated.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.isTruncated)
      .optionallyWith(
        marker.map(value => ResponseMarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.ListAccessKeysResponse.ReadOnly =
    zio.aws.iam.model.ListAccessKeysResponse.wrap(buildAwsValue())
}
object ListAccessKeysResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ListAccessKeysResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ListAccessKeysResponse =
      zio.aws.iam.model.ListAccessKeysResponse(
        accessKeyMetadata.map { item =>
          item.asEditable
        },
        isTruncated.map(value => value),
        marker.map(value => value)
      )
    def accessKeyMetadata: List[zio.aws.iam.model.AccessKeyMetadata.ReadOnly]
    def isTruncated: Option[BooleanType]
    def marker: Option[ResponseMarkerType]
    def getAccessKeyMetadata: ZIO[Any, Nothing, List[
      zio.aws.iam.model.AccessKeyMetadata.ReadOnly
    ]] = ZIO.succeed(accessKeyMetadata)
    def getIsTruncated: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("isTruncated", isTruncated)
    def getMarker: ZIO[Any, AwsError, ResponseMarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ListAccessKeysResponse
  ) extends zio.aws.iam.model.ListAccessKeysResponse.ReadOnly {
    override val accessKeyMetadata
        : List[zio.aws.iam.model.AccessKeyMetadata.ReadOnly] = impl
      .accessKeyMetadata()
      .asScala
      .map { item =>
        zio.aws.iam.model.AccessKeyMetadata.wrap(item)
      }
      .toList
    override val isTruncated: Option[BooleanType] = scala
      .Option(impl.isTruncated())
      .map(value => zio.aws.iam.model.primitives.BooleanType(value))
    override val marker: Option[ResponseMarkerType] = scala
      .Option(impl.marker())
      .map(value => zio.aws.iam.model.primitives.ResponseMarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ListAccessKeysResponse
  ): zio.aws.iam.model.ListAccessKeysResponse.ReadOnly = new Wrapper(impl)
}
