package zio.aws.iam.model
import java.lang.Integer
import zio.aws.iam.model.primitives.{
  MaxItemsType,
  MarkerType,
  PolicyPathType,
  GroupNameType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListAttachedGroupPoliciesRequest(
    groupName: GroupNameType,
    pathPrefix: Option[PolicyPathType] = None,
    marker: Option[MarkerType] = None,
    maxItems: Option[MaxItemsType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ListAttachedGroupPoliciesRequest = {
    import ListAttachedGroupPoliciesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ListAttachedGroupPoliciesRequest
      .builder()
      .groupName(GroupNameType.unwrap(groupName): java.lang.String)
      .optionallyWith(
        pathPrefix.map(value => PolicyPathType.unwrap(value): java.lang.String)
      )(_.pathPrefix)
      .optionallyWith(
        marker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        maxItems.map(value => MaxItemsType.unwrap(value): Integer)
      )(_.maxItems)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.ListAttachedGroupPoliciesRequest.ReadOnly =
    zio.aws.iam.model.ListAttachedGroupPoliciesRequest.wrap(buildAwsValue())
}
object ListAttachedGroupPoliciesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ListAttachedGroupPoliciesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ListAttachedGroupPoliciesRequest =
      zio.aws.iam.model.ListAttachedGroupPoliciesRequest(
        groupName,
        pathPrefix.map(value => value),
        marker.map(value => value),
        maxItems.map(value => value)
      )
    def groupName: GroupNameType
    def pathPrefix: Option[PolicyPathType]
    def marker: Option[MarkerType]
    def maxItems: Option[MaxItemsType]
    def getGroupName: ZIO[Any, Nothing, GroupNameType] = ZIO.succeed(groupName)
    def getPathPrefix: ZIO[Any, AwsError, PolicyPathType] =
      AwsError.unwrapOptionField("pathPrefix", pathPrefix)
    def getMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, MaxItemsType] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ListAttachedGroupPoliciesRequest
  ) extends zio.aws.iam.model.ListAttachedGroupPoliciesRequest.ReadOnly {
    override val groupName: GroupNameType =
      zio.aws.iam.model.primitives.GroupNameType(impl.groupName())
    override val pathPrefix: Option[PolicyPathType] = scala
      .Option(impl.pathPrefix())
      .map(value => zio.aws.iam.model.primitives.PolicyPathType(value))
    override val marker: Option[MarkerType] = scala
      .Option(impl.marker())
      .map(value => zio.aws.iam.model.primitives.MarkerType(value))
    override val maxItems: Option[MaxItemsType] = scala
      .Option(impl.maxItems())
      .map(value => zio.aws.iam.model.primitives.MaxItemsType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ListAttachedGroupPoliciesRequest
  ): zio.aws.iam.model.ListAttachedGroupPoliciesRequest.ReadOnly = new Wrapper(
    impl
  )
}
