package zio.aws.iam.model
import zio.aws.iam.model.primitives.{ResponseMarkerType, BooleanType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListAttachedRolePoliciesResponse(
    attachedPolicies: Option[Iterable[zio.aws.iam.model.AttachedPolicy]] = None,
    isTruncated: Option[BooleanType] = None,
    marker: Option[ResponseMarkerType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ListAttachedRolePoliciesResponse = {
    import ListAttachedRolePoliciesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ListAttachedRolePoliciesResponse
      .builder()
      .optionallyWith(
        attachedPolicies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attachedPolicies)
      .optionallyWith(
        isTruncated.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.isTruncated)
      .optionallyWith(
        marker.map(value => ResponseMarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.ListAttachedRolePoliciesResponse.ReadOnly =
    zio.aws.iam.model.ListAttachedRolePoliciesResponse.wrap(buildAwsValue())
}
object ListAttachedRolePoliciesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ListAttachedRolePoliciesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ListAttachedRolePoliciesResponse =
      zio.aws.iam.model.ListAttachedRolePoliciesResponse(
        attachedPolicies.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        isTruncated.map(value => value),
        marker.map(value => value)
      )
    def attachedPolicies
        : Option[List[zio.aws.iam.model.AttachedPolicy.ReadOnly]]
    def isTruncated: Option[BooleanType]
    def marker: Option[ResponseMarkerType]
    def getAttachedPolicies
        : ZIO[Any, AwsError, List[zio.aws.iam.model.AttachedPolicy.ReadOnly]] =
      AwsError.unwrapOptionField("attachedPolicies", attachedPolicies)
    def getIsTruncated: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("isTruncated", isTruncated)
    def getMarker: ZIO[Any, AwsError, ResponseMarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ListAttachedRolePoliciesResponse
  ) extends zio.aws.iam.model.ListAttachedRolePoliciesResponse.ReadOnly {
    override val attachedPolicies
        : Option[List[zio.aws.iam.model.AttachedPolicy.ReadOnly]] = scala
      .Option(impl.attachedPolicies())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iam.model.AttachedPolicy.wrap(item)
        }.toList
      )
    override val isTruncated: Option[BooleanType] = scala
      .Option(impl.isTruncated())
      .map(value => zio.aws.iam.model.primitives.BooleanType(value))
    override val marker: Option[ResponseMarkerType] = scala
      .Option(impl.marker())
      .map(value => zio.aws.iam.model.primitives.ResponseMarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ListAttachedRolePoliciesResponse
  ): zio.aws.iam.model.ListAttachedRolePoliciesResponse.ReadOnly = new Wrapper(
    impl
  )
}
