package zio.aws.iam.model
import java.lang.Integer
import zio.aws.iam.model.primitives.{
  MaxItemsType,
  MarkerType,
  PathType,
  ArnType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListEntitiesForPolicyRequest(
    policyArn: ArnType,
    entityFilter: Option[zio.aws.iam.model.EntityType] = None,
    pathPrefix: Option[PathType] = None,
    policyUsageFilter: Option[zio.aws.iam.model.PolicyUsageType] = None,
    marker: Option[MarkerType] = None,
    maxItems: Option[MaxItemsType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyRequest = {
    import ListEntitiesForPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyRequest
      .builder()
      .policyArn(ArnType.unwrap(policyArn): java.lang.String)
      .optionallyWith(entityFilter.map(value => value.unwrap))(_.entityFilter)
      .optionallyWith(
        pathPrefix.map(value => PathType.unwrap(value): java.lang.String)
      )(_.pathPrefix)
      .optionallyWith(policyUsageFilter.map(value => value.unwrap))(
        _.policyUsageFilter
      )
      .optionallyWith(
        marker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        maxItems.map(value => MaxItemsType.unwrap(value): Integer)
      )(_.maxItems)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.ListEntitiesForPolicyRequest.ReadOnly =
    zio.aws.iam.model.ListEntitiesForPolicyRequest.wrap(buildAwsValue())
}
object ListEntitiesForPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ListEntitiesForPolicyRequest =
      zio.aws.iam.model.ListEntitiesForPolicyRequest(
        policyArn,
        entityFilter.map(value => value),
        pathPrefix.map(value => value),
        policyUsageFilter.map(value => value),
        marker.map(value => value),
        maxItems.map(value => value)
      )
    def policyArn: ArnType
    def entityFilter: Option[zio.aws.iam.model.EntityType]
    def pathPrefix: Option[PathType]
    def policyUsageFilter: Option[zio.aws.iam.model.PolicyUsageType]
    def marker: Option[MarkerType]
    def maxItems: Option[MaxItemsType]
    def getPolicyArn: ZIO[Any, Nothing, ArnType] = ZIO.succeed(policyArn)
    def getEntityFilter: ZIO[Any, AwsError, zio.aws.iam.model.EntityType] =
      AwsError.unwrapOptionField("entityFilter", entityFilter)
    def getPathPrefix: ZIO[Any, AwsError, PathType] =
      AwsError.unwrapOptionField("pathPrefix", pathPrefix)
    def getPolicyUsageFilter
        : ZIO[Any, AwsError, zio.aws.iam.model.PolicyUsageType] =
      AwsError.unwrapOptionField("policyUsageFilter", policyUsageFilter)
    def getMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, MaxItemsType] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyRequest
  ) extends zio.aws.iam.model.ListEntitiesForPolicyRequest.ReadOnly {
    override val policyArn: ArnType =
      zio.aws.iam.model.primitives.ArnType(impl.policyArn())
    override val entityFilter: Option[zio.aws.iam.model.EntityType] = scala
      .Option(impl.entityFilter())
      .map(value => zio.aws.iam.model.EntityType.wrap(value))
    override val pathPrefix: Option[PathType] = scala
      .Option(impl.pathPrefix())
      .map(value => zio.aws.iam.model.primitives.PathType(value))
    override val policyUsageFilter: Option[zio.aws.iam.model.PolicyUsageType] =
      scala
        .Option(impl.policyUsageFilter())
        .map(value => zio.aws.iam.model.PolicyUsageType.wrap(value))
    override val marker: Option[MarkerType] = scala
      .Option(impl.marker())
      .map(value => zio.aws.iam.model.primitives.MarkerType(value))
    override val maxItems: Option[MaxItemsType] = scala
      .Option(impl.maxItems())
      .map(value => zio.aws.iam.model.primitives.MaxItemsType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyRequest
  ): zio.aws.iam.model.ListEntitiesForPolicyRequest.ReadOnly = new Wrapper(impl)
}
