package zio.aws.iam.model
import zio.aws.iam.model.primitives.{ResponseMarkerType, BooleanType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListEntitiesForPolicyResponse(
    policyGroups: Option[Iterable[zio.aws.iam.model.PolicyGroup]] = None,
    policyUsers: Option[Iterable[zio.aws.iam.model.PolicyUser]] = None,
    policyRoles: Option[Iterable[zio.aws.iam.model.PolicyRole]] = None,
    isTruncated: Option[BooleanType] = None,
    marker: Option[ResponseMarkerType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyResponse = {
    import ListEntitiesForPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyResponse
      .builder()
      .optionallyWith(
        policyGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.policyGroups)
      .optionallyWith(
        policyUsers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.policyUsers)
      .optionallyWith(
        policyRoles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.policyRoles)
      .optionallyWith(
        isTruncated.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.isTruncated)
      .optionallyWith(
        marker.map(value => ResponseMarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.ListEntitiesForPolicyResponse.ReadOnly =
    zio.aws.iam.model.ListEntitiesForPolicyResponse.wrap(buildAwsValue())
}
object ListEntitiesForPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ListEntitiesForPolicyResponse =
      zio.aws.iam.model.ListEntitiesForPolicyResponse(
        policyGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        policyUsers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        policyRoles.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        isTruncated.map(value => value),
        marker.map(value => value)
      )
    def policyGroups: Option[List[zio.aws.iam.model.PolicyGroup.ReadOnly]]
    def policyUsers: Option[List[zio.aws.iam.model.PolicyUser.ReadOnly]]
    def policyRoles: Option[List[zio.aws.iam.model.PolicyRole.ReadOnly]]
    def isTruncated: Option[BooleanType]
    def marker: Option[ResponseMarkerType]
    def getPolicyGroups
        : ZIO[Any, AwsError, List[zio.aws.iam.model.PolicyGroup.ReadOnly]] =
      AwsError.unwrapOptionField("policyGroups", policyGroups)
    def getPolicyUsers
        : ZIO[Any, AwsError, List[zio.aws.iam.model.PolicyUser.ReadOnly]] =
      AwsError.unwrapOptionField("policyUsers", policyUsers)
    def getPolicyRoles
        : ZIO[Any, AwsError, List[zio.aws.iam.model.PolicyRole.ReadOnly]] =
      AwsError.unwrapOptionField("policyRoles", policyRoles)
    def getIsTruncated: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("isTruncated", isTruncated)
    def getMarker: ZIO[Any, AwsError, ResponseMarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyResponse
  ) extends zio.aws.iam.model.ListEntitiesForPolicyResponse.ReadOnly {
    override val policyGroups
        : Option[List[zio.aws.iam.model.PolicyGroup.ReadOnly]] = scala
      .Option(impl.policyGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iam.model.PolicyGroup.wrap(item)
        }.toList
      )
    override val policyUsers
        : Option[List[zio.aws.iam.model.PolicyUser.ReadOnly]] = scala
      .Option(impl.policyUsers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iam.model.PolicyUser.wrap(item)
        }.toList
      )
    override val policyRoles
        : Option[List[zio.aws.iam.model.PolicyRole.ReadOnly]] = scala
      .Option(impl.policyRoles())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iam.model.PolicyRole.wrap(item)
        }.toList
      )
    override val isTruncated: Option[BooleanType] = scala
      .Option(impl.isTruncated())
      .map(value => zio.aws.iam.model.primitives.BooleanType(value))
    override val marker: Option[ResponseMarkerType] = scala
      .Option(impl.marker())
      .map(value => zio.aws.iam.model.primitives.ResponseMarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyResponse
  ): zio.aws.iam.model.ListEntitiesForPolicyResponse.ReadOnly = new Wrapper(
    impl
  )
}
