package zio.aws.iam.model
import zio.aws.iam.model.primitives.{ResponseMarkerType, BooleanType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListGroupsResponse(
    groups: Iterable[zio.aws.iam.model.Group],
    isTruncated: Option[BooleanType] = None,
    marker: Option[ResponseMarkerType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ListGroupsResponse = {
    import ListGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ListGroupsResponse
      .builder()
      .groups(groups.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        isTruncated.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.isTruncated)
      .optionallyWith(
        marker.map(value => ResponseMarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.ListGroupsResponse.ReadOnly =
    zio.aws.iam.model.ListGroupsResponse.wrap(buildAwsValue())
}
object ListGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ListGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ListGroupsResponse =
      zio.aws.iam.model.ListGroupsResponse(
        groups.map { item =>
          item.asEditable
        },
        isTruncated.map(value => value),
        marker.map(value => value)
      )
    def groups: List[zio.aws.iam.model.Group.ReadOnly]
    def isTruncated: Option[BooleanType]
    def marker: Option[ResponseMarkerType]
    def getGroups: ZIO[Any, Nothing, List[zio.aws.iam.model.Group.ReadOnly]] =
      ZIO.succeed(groups)
    def getIsTruncated: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("isTruncated", isTruncated)
    def getMarker: ZIO[Any, AwsError, ResponseMarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ListGroupsResponse
  ) extends zio.aws.iam.model.ListGroupsResponse.ReadOnly {
    override val groups: List[zio.aws.iam.model.Group.ReadOnly] = impl
      .groups()
      .asScala
      .map { item =>
        zio.aws.iam.model.Group.wrap(item)
      }
      .toList
    override val isTruncated: Option[BooleanType] = scala
      .Option(impl.isTruncated())
      .map(value => zio.aws.iam.model.primitives.BooleanType(value))
    override val marker: Option[ResponseMarkerType] = scala
      .Option(impl.marker())
      .map(value => zio.aws.iam.model.primitives.ResponseMarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ListGroupsResponse
  ): zio.aws.iam.model.ListGroupsResponse.ReadOnly = new Wrapper(impl)
}
