package zio.aws.iam.model
import java.lang.Integer
import zio.aws.iam.model.primitives.{
  MaxItemsType,
  MarkerType,
  InstanceProfileNameType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListInstanceProfileTagsRequest(
    instanceProfileName: InstanceProfileNameType,
    marker: Option[MarkerType] = None,
    maxItems: Option[MaxItemsType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ListInstanceProfileTagsRequest = {
    import ListInstanceProfileTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ListInstanceProfileTagsRequest
      .builder()
      .instanceProfileName(
        InstanceProfileNameType.unwrap(instanceProfileName): java.lang.String
      )
      .optionallyWith(
        marker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        maxItems.map(value => MaxItemsType.unwrap(value): Integer)
      )(_.maxItems)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.ListInstanceProfileTagsRequest.ReadOnly =
    zio.aws.iam.model.ListInstanceProfileTagsRequest.wrap(buildAwsValue())
}
object ListInstanceProfileTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ListInstanceProfileTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ListInstanceProfileTagsRequest =
      zio.aws.iam.model.ListInstanceProfileTagsRequest(
        instanceProfileName,
        marker.map(value => value),
        maxItems.map(value => value)
      )
    def instanceProfileName: InstanceProfileNameType
    def marker: Option[MarkerType]
    def maxItems: Option[MaxItemsType]
    def getInstanceProfileName: ZIO[Any, Nothing, InstanceProfileNameType] =
      ZIO.succeed(instanceProfileName)
    def getMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, MaxItemsType] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ListInstanceProfileTagsRequest
  ) extends zio.aws.iam.model.ListInstanceProfileTagsRequest.ReadOnly {
    override val instanceProfileName: InstanceProfileNameType =
      zio.aws.iam.model.primitives
        .InstanceProfileNameType(impl.instanceProfileName())
    override val marker: Option[MarkerType] = scala
      .Option(impl.marker())
      .map(value => zio.aws.iam.model.primitives.MarkerType(value))
    override val maxItems: Option[MaxItemsType] = scala
      .Option(impl.maxItems())
      .map(value => zio.aws.iam.model.primitives.MaxItemsType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ListInstanceProfileTagsRequest
  ): zio.aws.iam.model.ListInstanceProfileTagsRequest.ReadOnly = new Wrapper(
    impl
  )
}
